/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.utils;

import br.com.climb.core.mapping.Json;
import br.com.climb.modelbean.ModelTableField;
import br.com.climb.utils.ReflectionUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    public static synchronized byte[] getBinaryValue(Connection connection, String sql, String field) throws SQLException {
        try (Statement stmt = connection.createStatement(1005, 1);
             ResultSet resultSet = stmt.executeQuery(sql);){
            if (resultSet.next()) {
                byte[] byArray = resultSet.getBytes(field);
                return byArray;
            }
        }
        return null;
    }

    public static synchronized PreparedStatement preparedStatementInsert(Connection connection, List<ModelTableField> modelTableFields, String sql) throws SQLException, InvocationTargetException, IntrospectionException, IllegalAccessException, JsonProcessingException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, 1);
        return SqlUtil.getPreparedStatement(preparedStatement, modelTableFields);
    }

    public static synchronized PreparedStatement preparedStatementUpdate(Connection connection, List<ModelTableField> modelTableFields, String sql) throws SQLException, InvocationTargetException, IntrospectionException, IllegalAccessException, JsonProcessingException {
        System.out.println("UPDATE: " + sql);
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        return SqlUtil.getPreparedStatement(preparedStatement, modelTableFields);
    }

    public static synchronized PreparedStatement getPreparedStatementDynamicFields(PreparedStatement ps, Map<String, Object> fields, int start) throws Exception {
        int i = start;
        for (String fieldName : fields.keySet()) {
            System.out.println("Nome: " + fieldName);
            Object object = fields.get(fieldName);
            ++i;
            if (object == null) {
                ps.setNull(i, 1);
                continue;
            }
            if (object.getClass() == Long.class || object.getClass() == Long.TYPE) {
                ps.setLong(i, (Long)object);
                continue;
            }
            if (object.getClass() == Integer.class || object.getClass() == Integer.TYPE) {
                ps.setInt(i, (Integer)object);
                continue;
            }
            if (object.getClass() == Float.class || object.getClass() == Float.TYPE) {
                ps.setFloat(i, ((Float)object).floatValue());
                continue;
            }
            if (object.getClass() == Double.class || object.getClass() == Double.TYPE) {
                ps.setDouble(i, (Double)object);
                continue;
            }
            if (object.getClass() == Boolean.class || object.getClass() == Boolean.TYPE) {
                ps.setBoolean(i, (Boolean)object);
                continue;
            }
            if (object.getClass() == String.class || object.getClass() == Character.TYPE) {
                ps.setString(i, (String)object);
                continue;
            }
            if (object.getClass() != byte[].class) continue;
            ps.setBytes(i, (byte[])object);
        }
        return ps;
    }

    public static synchronized PreparedStatement getPreparedStatement(PreparedStatement ps, List<ModelTableField> modelTableFields) throws IntrospectionException, SQLException, JsonProcessingException, InvocationTargetException, IllegalAccessException {
        int i = 0;
        for (ModelTableField modelTableField : modelTableFields) {
            ++i;
            if (modelTableField.getType() == Long.class || modelTableField.getType() == Long.TYPE) {
                if (ReflectionUtil.isProxedCGLIB(modelTableField.getValue())) {
                    Object value = new PropertyDescriptor("id", modelTableField.getValue().getClass().getSuperclass()).getReadMethod().invoke(modelTableField.getValue(), new Object[0]);
                    ps.setLong(i, (Long)value);
                    continue;
                }
                if (modelTableField.getValue() != null) {
                    ps.setLong(i, (Long)modelTableField.getValue());
                    continue;
                }
                ps.setNull(i, 0);
                continue;
            }
            if (modelTableField.getType() == Integer.class || modelTableField.getType() == Integer.TYPE) {
                if (modelTableField.getValue() == null) {
                    ps.setNull(i, 0);
                    continue;
                }
                ps.setInt(i, (Integer)modelTableField.getValue());
                continue;
            }
            if (modelTableField.getType() == Float.class || modelTableField.getType() == Float.TYPE) {
                if (modelTableField.getValue() == null) {
                    ps.setNull(i, 0);
                    continue;
                }
                ps.setFloat(i, ((Float)modelTableField.getValue()).floatValue());
                continue;
            }
            if (modelTableField.getType() == Double.class || modelTableField.getType() == Double.TYPE) {
                if (modelTableField.getValue() == null) {
                    ps.setNull(i, 0);
                    continue;
                }
                ps.setDouble(i, (Double)modelTableField.getValue());
                continue;
            }
            if (modelTableField.getType() == Boolean.class || modelTableField.getType() == Boolean.TYPE) {
                if (modelTableField.getValue() == null) {
                    ps.setNull(i, 0);
                    continue;
                }
                ps.setBoolean(i, (Boolean)modelTableField.getValue());
                continue;
            }
            if (modelTableField.getType() == String.class || modelTableField.getType() == Character.TYPE) {
                if (modelTableField.getValue() == null) {
                    ps.setNull(i, 0);
                    continue;
                }
                ps.setString(i, modelTableField.getValue().toString());
                continue;
            }
            if (modelTableField.getType() == byte[].class) {
                if (modelTableField.getValue() == null) {
                    ps.setNull(i, 0);
                    continue;
                }
                ps.setBytes(i, (byte[])modelTableField.getValue());
                continue;
            }
            if (modelTableField.getType() != List.class || !modelTableField.getField().isAnnotationPresent(Json.class)) continue;
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(modelTableField.getValue());
            ps.setObject(i, jsonString);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, String> getCreatedFields(String tableName, Connection connection) {
        String sql = "SELECT column_name, data_type FROM information_schema.columns WHERE \ntable_name = ?;";
        HashMap<String, String> map = null;
        Statement ps = null;
        try {
            map = new HashMap<String, String>();
            ps = connection.prepareStatement("SELECT column_name, data_type FROM information_schema.columns WHERE \ntable_name = ?;");
            ps.setString(1, tableName);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                map.put(rs.getString("column_name"), rs.getString("data_type"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static synchronized String getTypeDataBase(Class type) {
        if (type == Long.class || type == Long.TYPE) {
            return "bigint";
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return "integer";
        }
        if (type == Float.class || type == Float.TYPE) {
            return "decimal";
        }
        if (type == Double.class || type == Double.TYPE) {
            return "double precision";
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return "boolean";
        }
        if (type == String.class || type == Character.TYPE) {
            return "text";
        }
        if (type == byte[].class || type == Byte[].class) {
            return "bytea";
        }
        new Error("Not suportend type: " + type);
        return null;
    }

    public static synchronized Class getTypeDataJava(String type) {
        if ("integer".equals(type)) {
            return Integer.class;
        }
        if ("bigint".equals(type)) {
            return Long.class;
        }
        if ("decimal".equals(type) || "numeric".equals(type)) {
            return Float.class;
        }
        if ("double precision".equals(type)) {
            return Double.class;
        }
        if ("boolean".equals(type)) {
            return Boolean.class;
        }
        if ("text".equals(type)) {
            return String.class;
        }
        if ("bytea".equals(type)) {
            return byte[].class;
        }
        new Error("Not suportend type: " + type);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean isTableExist(Connection connection, String schema, String table) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT to_regclass('" + schema + "." + table + "') is not null");
            if (rs.next()) {
                boolean bl = rs.getBoolean(1);
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

