/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.core.sqlengine;

import br.com.climb.core.PersistentEntity;
import br.com.climb.core.sqlengine.ModelEngine;
import br.com.climb.core.sqlengine.interfaces.SqlEngine;
import br.com.climb.modelbean.ModelTableField;
import br.com.climb.utils.ReflectionUtil;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MySqlEngine
extends ModelEngine
implements SqlEngine {
    private static final Logger logger = LogManager.getLogger(MySqlEngine.class);

    @Override
    public String generateInsert(List<ModelTableField> modelTableFields, Object entity) {
        StringBuilder attributes = new StringBuilder();
        StringBuilder values = new StringBuilder();
        modelTableFields.stream().forEach(modelTableField -> {
            attributes.append(modelTableField.getAttribute() + ",");
            values.append("?,");
        });
        String tableName = ReflectionUtil.getTableName(entity);
        String sql = "INSERT INTO " + tableName + "(" + attributes.toString().substring(0, attributes.toString().length() - 1) + ") VALUES (" + values.toString().substring(0, values.toString().length() - 1) + ")";
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateUpdate(List<ModelTableField> modelTableFields, Object entity) {
        StringBuilder values = new StringBuilder();
        modelTableFields.stream().forEach(modelTableField -> values.append(modelTableField.getAttribute() + "= ?,"));
        String tableName = ReflectionUtil.getTableName(entity);
        Long id = ((PersistentEntity)entity).getId();
        String sql = "UPDATE " + tableName + " SET " + values.toString().substring(0, values.toString().length() - 1) + " WHERE id = " + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateDelete(Object entity) {
        String tableName = ReflectionUtil.getTableName(entity);
        Long id = ((PersistentEntity)entity).getId();
        String sql = "DELETE FROM " + tableName + " WHERE id = " + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateDelete(Class classe, String where) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        String sql = "DELETE FROM " + tableName + " " + where;
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateSelectMany(Class classe, String where) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        StringBuilder attributes = this.getAttributes(classe);
        String sql = "SELECT id," + attributes.toString().substring(0, attributes.toString().length() - 1) + " FROM " + tableName + " " + where;
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateSelectMany(Class classe) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        return "SELECT * FROM " + tableName;
    }

    @Override
    public String generateSelectOne(Class classe, Long id) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        StringBuilder attributes = this.getAttributes(classe);
        String sql = "SELECT id," + attributes.toString().substring(0, attributes.toString().length() - 1) + " FROM " + tableName + " WHERE ID=" + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateSelectOneAtt(Long id, String field, String entity) {
        String sql = "SELECT " + field + " FROM " + entity + " WHERE ID = " + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }
}

