/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.core.sgdbconnection;

import br.com.climb.configfile.interfaces.ConfigFile;
import br.com.climb.core.LazyLoader;
import br.com.climb.core.PersistentEntity;
import br.com.climb.core.TransactionDB;
import br.com.climb.core.interfaces.ClimbConnection;
import br.com.climb.core.interfaces.ResultIterator;
import br.com.climb.core.interfaces.Transaction;
import br.com.climb.core.jdbcconnection.FactoryJdbcConnection;
import br.com.climb.core.sqlengine.FactorySqlEngine;
import br.com.climb.core.sqlengine.interfaces.SqlEngine;
import br.com.climb.exception.SgdbException;
import br.com.climb.modelbean.ModelTableField;
import br.com.climb.systemcache.CacheManager;
import br.com.climb.systemcache.CacheManagerImp;
import br.com.climb.utils.ReflectionUtil;
import br.com.climb.utils.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ConnectionOperation
implements ClimbConnection {
    private static final Logger logger = LogManager.getLogger(ConnectionOperation.class);
    private Connection connection;
    private Transaction transaction;
    private SqlEngine sqlEngine;
    private CacheManager cacheManager;

    public ConnectionOperation(ConfigFile configFile) {
        try {
            this.connection = FactoryJdbcConnection.createJdbcConnection(configFile);
            this.transaction = new TransactionDB(this.connection);
            this.sqlEngine = FactorySqlEngine.generateSqlEngine(configFile);
            this.cacheManager = CacheManagerImp.build(configFile);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected SqlEngine getSqlEngine() {
        return this.sqlEngine;
    }

    @Override
    public void save(Object object) {
        block27: {
            try {
                List<ModelTableField> modelTableFields = ReflectionUtil.generateModel(object);
                try (PreparedStatement preparedStatement = SqlUtil.preparedStatementInsert(this.connection, modelTableFields, this.sqlEngine.generateInsert(modelTableFields, object));){
                    preparedStatement.executeUpdate();
                    try (ResultSet rsID = preparedStatement.getGeneratedKeys();){
                        if (rsID.next()) {
                            ((PersistentEntity)object).setId(rsID.getLong(1));
                            this.cacheManager.addToCache(object);
                            break block27;
                        }
                        throw new SgdbException("FATAL ERROR: it was not possible to obtain the sequential code after the insert");
                    }
                }
            }
            catch (Exception e) {
                logger.error("context", (Throwable)e);
            }
        }
    }

    @Override
    public void update(Object object) {
        try {
            List<ModelTableField> modelTableFields = ReflectionUtil.generateModel(object);
            try (PreparedStatement preparedStatement = SqlUtil.preparedStatementUpdate(this.connection, modelTableFields, this.sqlEngine.generateUpdate(modelTableFields, object));){
                preparedStatement.executeUpdate();
                this.cacheManager.addToCache(object);
            }
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
        }
    }

    @Override
    public void update(String query) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(query);){
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
        }
    }

    @Override
    public void delete(Object object) {
        try {
            List<ModelTableField> modelTableFields = ReflectionUtil.generateModel(object);
            try (Statement statement = this.connection.createStatement();){
                statement.execute(this.sqlEngine.generateDelete(object));
                ((PersistentEntity)object).setId(null);
            }
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
        }
    }

    @Override
    public void delete(Class object, String where) {
        try (Statement statement = this.connection.createStatement();){
            statement.execute(this.sqlEngine.generateDelete(object, where));
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
        }
    }

    @Override
    public void delete(String query) {
        try (Statement statement = this.connection.createStatement();){
            statement.execute(query);
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            logger.error("context", (Throwable)e);
        }
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public Object findOne(Class classe, Long id) {
        try {
            return new LazyLoader(this.connection, this.sqlEngine).loadLazyObject(classe, id);
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
            return null;
        }
    }

    @Override
    public ResultIterator find(Class classe, String where) {
        try {
            return new LazyLoader(this.connection, this.sqlEngine, classe).findWithWhereQueryExecute(this.sqlEngine.generateSelectMany(classe, where));
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
            return null;
        }
    }

    @Override
    public ResultIterator find(Class classe) {
        try {
            return new LazyLoader(this.connection, this.sqlEngine, classe).findWithWhereQueryExecute(this.sqlEngine.generateSelectMany(classe));
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
            return null;
        }
    }

    @Override
    public ResultIterator findWithQuery(Class classe, String sql) {
        try {
            return new LazyLoader(this.connection, this.sqlEngine, classe).findWithQueryExecute(sql);
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
            return null;
        }
    }
}

