package br.com.climb.core.sqlengine;

import br.com.climb.core.PersistentEntity;
import br.com.climb.core.mapping.Json;
import br.com.climb.core.sqlengine.interfaces.HasSchema;
import br.com.climb.core.sqlengine.interfaces.SqlEngine;
import br.com.climb.modelbean.ModelTableField;
import org.apache.logging.log4j.Logger;

import static br.com.climb.utils.ReflectionUtil.getTableName;
import static org.apache.logging.log4j.LogManager.getLogger;

import java.util.List;

public class PostgresSqlEngine extends ModelEngine implements SqlEngine, HasSchema {

    private static final Logger logger = getLogger(PostgresSqlEngine.class);
    private String schema = "public";
    public PostgresSqlEngine() {}

    @Override
    public String generateInsert(List<ModelTableField> modelTableFields, Object entity) {

        final StringBuilder attributes = new StringBuilder();
        final StringBuilder values = new StringBuilder();

        modelTableFields.stream().forEach((modelTableField) -> {
            attributes.append(modelTableField.getAttribute() + ",");
            if (modelTableField.getField().isAnnotationPresent(Json.class)) {
                Json json = modelTableField.getField().getAnnotation(Json.class);
                values.append("?::"+json.typeJson()+",");
            } else {
                values.append("?,");
            }
        });

        final String tableName = getTableName(entity);

        final String sql = "INSERT INTO " + schema + "." + tableName + "("
                + attributes.toString().substring(0, attributes.toString().length() - 1) + ") VALUES ("
                + values.toString().substring(0, values.toString().length() -1) + ") RETURNING ID";

        logger.info("SQL-POSTGRES: ", sql);
        return sql;
    }

    @Override
    public String generateUpdate(List<ModelTableField> modelTableFields, Object entity) {

        final StringBuilder values = new StringBuilder();

        modelTableFields.stream().forEach((modelTableField) -> {
            if (modelTableField.getField().isAnnotationPresent(Json.class)) {
                values.append(modelTableField.getAttribute() + "= ?::JSON,");
            } else {
                values.append(modelTableField.getAttribute() + "= ?,");
            }
        });

        final String tableName = getTableName(entity);
        final Long id = ((PersistentEntity)entity).getId();

        final String sql = "UPDATE " + schema + "." + tableName + " SET " +
                "" + values.toString().substring(0, values.toString().length() -1) + " " +
                "" + "WHERE id = " + id.toString();

        logger.info("SQL-POSTGRES: ", sql);

//        System.out.println(sql);

        return sql;
    }

    @Override
    public String generateDelete(Object entity) {

        final String tableName = getTableName(entity);
        final Long id = ((PersistentEntity)entity).getId();
        final String sql = "DELETE FROM " + schema + "." + tableName + " WHERE id = " + id.toString();

        logger.info("SQL-POSTGRES: ", sql);

        return sql;
    }

    @Override
    public String generateDelete(Class classe, String where) throws Exception {
        final String tableName = getTableName(classe.getDeclaredConstructor().newInstance());
        final String sql = "DELETE FROM " + schema + "." + tableName + " " + where;

        logger.info("SQL-POSTGRES: ", sql);

        return sql;
    }

    @Override
    public String generateSelectMany(Class classe, String where) throws Exception {

        final String tableName = getTableName(classe.getDeclaredConstructor().newInstance());
        final StringBuilder attributes = getAttributes(classe);

        final String sql = "SELECT id," + attributes.toString().substring(0, attributes.toString().length() - 1) + " FROM "
            + schema + "." + tableName + " " + where;

        logger.info("SQL-POSTGRES: ", sql);

        return sql;

    }

    @Override
    public String generateSelectMany(Class classe) throws Exception {
        final String tableName = getTableName(classe.getDeclaredConstructor().newInstance());
        return "SELECT * FROM " + schema + "."+ tableName;
    }

    @Override
    public String generateSelectOne(Class classe, Long id) throws Exception {

        final String tableName = getTableName(classe.getDeclaredConstructor().newInstance());
        final StringBuilder attributes = getAttributes(classe);

        final String sql = "SELECT id," + attributes.toString().substring(0, attributes.toString().length() - 1) + " FROM " +
                schema + "."+ tableName + " WHERE ID="+id.toString();

        logger.info("SQL-POSTGRES: ", sql);

        return sql;

    }

    public String generateSelectOneAtt(Long id, String field, String entity) {

        final String sql = "SELECT " + field + " FROM " + schema + "." + entity + " WHERE ID = " + id.toString();

        logger.info("SQL-POSTGRES: ", sql);

        return sql;

    }


    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getSchema() {
        return schema;
    }
}
