/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.core;

import br.com.climb.configfile.interfaces.ConfigFile;
import br.com.climb.core.interfaces.ClimbConnection;
import br.com.climb.core.interfaces.ManagerFactory;
import br.com.climb.core.sgdbconnection.MySqlConnection;
import br.com.climb.core.sgdbconnection.PostgresConnection;
import br.com.climb.exception.SgdbException;

public class Manager
implements ManagerFactory {
    private ConfigFile configFile;

    public Manager(ConfigFile configFile) {
        this.configFile = configFile;
    }

    @Override
    public ClimbConnection getConnection() throws SgdbException {
        if (this.configFile.getDriver().equals("org.postgresql.Driver")) {
            return new PostgresConnection(this.configFile);
        }
        if (this.configFile.getDriver().equals("com.mysql.jdbc.Driver")) {
            return new MySqlConnection(this.configFile);
        }
        throw new SgdbException("Connection driver not supported: " + this.configFile.getDriver());
    }

    @Override
    public ClimbConnection getConnection(String schemaName) throws SgdbException {
        if (this.configFile.getDriver().equals("org.postgresql.Driver")) {
            PostgresConnection climbConnection = new PostgresConnection(this.configFile);
            climbConnection.setSchema(schemaName);
            return climbConnection;
        }
        if (this.configFile.getDriver().equals("com.mysql.jdbc.Driver")) {
            return new MySqlConnection(this.configFile);
        }
        throw new SgdbException("Connection driver not supported: " + this.configFile.getDriver());
    }
}

