/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.utils;

import br.com.climb.core.PersistentEntity;
import br.com.climb.core.mapping.Column;
import br.com.climb.core.mapping.DynamicField;
import br.com.climb.core.mapping.Entity;
import br.com.climb.core.mapping.ID;
import br.com.climb.core.mapping.Json;
import br.com.climb.core.mapping.Relation;
import br.com.climb.core.mapping.Transient;
import br.com.climb.modelbean.ModelTableField;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtil {
    private static final Logger logger = LogManager.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static synchronized String getFieldName(Field field) {
        String fieldName = field.getName();
        Column column = field.getAnnotation(Column.class);
        if (column != null && column.name().trim().length() > 0) {
            fieldName = column.name();
        }
        return fieldName;
    }

    public static synchronized Field getDynamicField(Object object) {
        Field field = null;
        Field[] fields = null;
        fields = ReflectionUtil.isProxedCGLIB(object) ? object.getClass().getSuperclass().getDeclaredFields() : object.getClass().getDeclaredFields();
        return field;
    }

    public static synchronized boolean isContainsDynamicFields(Object object) {
        boolean exist = false;
        Field[] fields = null;
        if (object == null) {
            return false;
        }
        fields = ReflectionUtil.isProxedCGLIB(object) ? object.getClass().getSuperclass().getDeclaredFields() : object.getClass().getDeclaredFields();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(DynamicField.class)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static synchronized void setValueField(Field field, Object object, Object value) {
        try {
            new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public static synchronized Object getValueField(Field field, Object object) {
        Object tempValue = null;
        try {
            Object value = new PropertyDescriptor(field.getName(), object.getClass()).getReadMethod().invoke(object, new Object[0]);
            if (value == null) {
                return null;
            }
            tempValue = value != null && value.getClass().isAnnotationPresent(Entity.class) ? ((PersistentEntity)value).getId() : value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempValue;
    }

    public static synchronized boolean isProxedCGLIB(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().getName().contains("EnhancerByCGLI");
    }

    public static synchronized String getTableName(Object object) {
        Entity entity = null;
        entity = ReflectionUtil.isProxedCGLIB(object) ? object.getClass().getSuperclass().getAnnotation(Entity.class) : object.getClass().getAnnotation(Entity.class);
        String tableName = "";
        if (entity == null || entity.name().trim().length() <= 0) {
            throw new Error("ERROR: " + object.getClass().getName() + " Unnamed entity ");
        }
        tableName = entity.name().trim().toLowerCase();
        return tableName;
    }

    public static synchronized List<ModelTableField> generateModel(Object object) {
        ArrayList<ModelTableField> modelTableFields = new ArrayList<ModelTableField>();
        Field[] fields = null;
        fields = ReflectionUtil.isProxedCGLIB(object) ? object.getClass().getSuperclass().getDeclaredFields() : object.getClass().getDeclaredFields();
        for (Field field : fields) {
            Object tempValue;
            String fieldName;
            ID id;
            Object tempValue2;
            String fieldName2;
            if (field.isAnnotationPresent(Transient.class)) continue;
            if (field.isAnnotationPresent(Relation.class)) {
                fieldName2 = ReflectionUtil.getFieldName(field);
                tempValue2 = ReflectionUtil.getValueField(field, object);
                modelTableFields.add(new ModelTableField(fieldName2, tempValue2, Long.class, field));
                continue;
            }
            if (field.getType() == Long.class) {
                try {
                    id = field.getAnnotation(ID.class);
                    if (id != null && id.sequencial()) continue;
                    fieldName = ReflectionUtil.getFieldName(field);
                    tempValue = ReflectionUtil.getValueField(field, object);
                    modelTableFields.add(new ModelTableField(fieldName, tempValue, Long.class, field));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (field.getType() == Integer.class) {
                try {
                    id = field.getAnnotation(ID.class);
                    if (id != null && id.sequencial()) continue;
                    fieldName = ReflectionUtil.getFieldName(field);
                    tempValue = ReflectionUtil.getValueField(field, object);
                    modelTableFields.add(new ModelTableField(fieldName, tempValue, Integer.class, field));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                try {
                    fieldName2 = ReflectionUtil.getFieldName(field);
                    tempValue2 = ReflectionUtil.getValueField(field, object);
                    modelTableFields.add(new ModelTableField(fieldName2, tempValue2, Float.class, field));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                try {
                    fieldName2 = ReflectionUtil.getFieldName(field);
                    tempValue2 = ReflectionUtil.getValueField(field, object);
                    modelTableFields.add(new ModelTableField(fieldName2, tempValue2, Double.class, field));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                try {
                    fieldName2 = ReflectionUtil.getFieldName(field);
                    tempValue2 = ReflectionUtil.getValueField(field, object);
                    modelTableFields.add(new ModelTableField(fieldName2, tempValue2, Boolean.class, field));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (field.getType() == String.class || field.getType() == Character.TYPE) {
                try {
                    fieldName2 = ReflectionUtil.getFieldName(field);
                    tempValue2 = ReflectionUtil.getValueField(field, object);
                    modelTableFields.add(new ModelTableField(fieldName2, tempValue2, String.class, field));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (field.getType() == byte[].class) {
                try {
                    fieldName2 = ReflectionUtil.getFieldName(field);
                    tempValue2 = ReflectionUtil.getValueField(field, object);
                    modelTableFields.add(new ModelTableField(fieldName2, tempValue2, byte[].class, field));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (field.getType() != List.class || !field.isAnnotationPresent(Json.class)) continue;
            try {
                fieldName2 = ReflectionUtil.getFieldName(field);
                tempValue2 = ReflectionUtil.getValueField(field, object);
                modelTableFields.add(new ModelTableField(fieldName2, tempValue2, List.class, field));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return modelTableFields;
    }
}

