/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.core.sqlengine;

import br.com.climb.core.PersistentEntity;
import br.com.climb.core.mapping.Json;
import br.com.climb.core.sqlengine.ModelEngine;
import br.com.climb.core.sqlengine.interfaces.HasSchema;
import br.com.climb.core.sqlengine.interfaces.SqlEngine;
import br.com.climb.modelbean.ModelTableField;
import br.com.climb.utils.ReflectionUtil;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostgresSqlEngine
extends ModelEngine
implements SqlEngine,
HasSchema {
    private static final Logger logger = LogManager.getLogger(PostgresSqlEngine.class);
    private String schema = "public";

    @Override
    public String generateInsert(List<ModelTableField> modelTableFields, Object entity) {
        StringBuilder attributes = new StringBuilder();
        StringBuilder values = new StringBuilder();
        modelTableFields.stream().forEach(modelTableField -> {
            attributes.append(modelTableField.getAttribute() + ",");
            if (modelTableField.getField().isAnnotationPresent(Json.class)) {
                Json json = modelTableField.getField().getAnnotation(Json.class);
                values.append("?::" + json.typeJson() + ",");
            } else {
                values.append("?,");
            }
        });
        String tableName = ReflectionUtil.getTableName(entity);
        String sql = "INSERT INTO " + this.schema + "." + tableName + "(" + attributes.toString().substring(0, attributes.toString().length() - 1) + ") VALUES (" + values.toString().substring(0, values.toString().length() - 1) + ") RETURNING ID";
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateUpdate(List<ModelTableField> modelTableFields, Object entity) {
        StringBuilder values = new StringBuilder();
        modelTableFields.stream().forEach(modelTableField -> {
            if (modelTableField.getField().isAnnotationPresent(Json.class)) {
                values.append(modelTableField.getAttribute() + "= ?::JSON,");
            } else {
                values.append(modelTableField.getAttribute() + "= ?,");
            }
        });
        String tableName = ReflectionUtil.getTableName(entity);
        Long id = ((PersistentEntity)entity).getId();
        String sql = "UPDATE " + this.schema + "." + tableName + " SET " + values.toString().substring(0, values.toString().length() - 1) + " WHERE id = " + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateDelete(Object entity) {
        String tableName = ReflectionUtil.getTableName(entity);
        Long id = ((PersistentEntity)entity).getId();
        String sql = "DELETE FROM " + this.schema + "." + tableName + " WHERE id = " + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateDelete(Class classe, String where) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        String sql = "DELETE FROM " + this.schema + "." + tableName + " " + where;
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateSelectMany(Class classe, String where) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        StringBuilder attributes = this.getAttributes(classe);
        String sql = "SELECT id," + attributes.toString().substring(0, attributes.toString().length() - 1) + " FROM " + this.schema + "." + tableName + " " + where;
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateSelectMany(Class classe) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        return "SELECT * FROM " + this.schema + "." + tableName;
    }

    @Override
    public String generateSelectOne(Class classe, Long id) throws Exception {
        String tableName = ReflectionUtil.getTableName(classe.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        StringBuilder attributes = this.getAttributes(classe);
        String sql = "SELECT id," + attributes.toString().substring(0, attributes.toString().length() - 1) + " FROM " + this.schema + "." + tableName + " WHERE ID=" + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public String generateSelectOneAtt(Long id, String field, String entity) {
        String sql = "SELECT " + field + " FROM " + this.schema + "." + entity + " WHERE ID = " + id.toString();
        logger.info("SQL-POSTGRES: ", (Object)sql);
        return sql;
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }
}

