/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.core.jdbcconnection;

import br.com.climb.configfile.interfaces.ConfigFile;
import br.com.climb.exception.SgdbException;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactoryJdbcConnection {
    private static final Logger logger = LogManager.getLogger(FactoryJdbcConnection.class);
    private static HikariConfig hikariConfig = new HikariConfig();
    private static HikariDataSource hikariDataSource;

    private FactoryJdbcConnection() {
    }

    protected static String getJdbcUrl(ConfigFile configFile) throws SgdbException {
        if (configFile.getDriver().equals("org.postgresql.Driver")) {
            return "jdbc:postgresql://" + configFile.getUrl() + ":" + configFile.getPort() + "/" + configFile.getDatabase();
        }
        if (configFile.getDriver().equals("com.mysql.jdbc.Driver")) {
            return "jdbc:mysql://" + configFile.getUrl() + ":" + configFile.getPort() + "/" + configFile.getDatabase();
        }
        throw new SgdbException("unsupported database");
    }

    public static Connection createJdbcConnection(ConfigFile configFile) throws SQLException {
        Connection connection = null;
        try {
            if (connection == null || connection.isClosed()) {
                hikariConfig.setJdbcUrl(FactoryJdbcConnection.getJdbcUrl(configFile));
                hikariConfig.setUsername(configFile.getUser());
                hikariConfig.setPassword(configFile.getPassword());
                hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)"true");
                hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                hikariDataSource = new HikariDataSource(hikariConfig);
                connection = hikariDataSource.getConnection();
            }
        }
        catch (SgdbException | SQLException e) {
            logger.error("context", (Throwable)e);
        }
        return connection;
    }
}

