/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.core;

import br.com.climb.configfile.interfaces.ConfigFile;
import br.com.climb.core.interfaces.ClimbConnection;
import br.com.climb.core.interfaces.ManagerFactory;
import br.com.climb.core.sgdbconnection.ConnectionOperation;
import br.com.climb.core.sgdbconnection.MySqlConnection;
import br.com.climb.core.sgdbconnection.PostgresConnection;
import br.com.climb.core.sqlengine.interfaces.HasSchema;

public class Manager
implements ManagerFactory {
    private ConfigFile configFile;

    public Manager(ConfigFile configFile) {
        this.configFile = configFile;
    }

    @Override
    public ClimbConnection getConnection() {
        ConnectionOperation climbConnection = null;
        if (this.configFile.getDriver().equals("org.postgresql.Driver")) {
            climbConnection = new PostgresConnection(this.configFile);
        }
        if (this.configFile.getDriver().equals("com.mysql.jdbc.Driver")) {
            climbConnection = new MySqlConnection(this.configFile);
        }
        return climbConnection;
    }

    @Override
    public ClimbConnection getConnection(String schemaName) {
        ConnectionOperation climbConnection = null;
        if (this.configFile.getDriver().equals("org.postgresql.Driver")) {
            climbConnection = new PostgresConnection(this.configFile);
            ((HasSchema)((Object)climbConnection)).setSchema(schemaName);
        }
        if (this.configFile.getDriver().equals("com.mysql.jdbc.Driver")) {
            climbConnection = new MySqlConnection(this.configFile);
        }
        return climbConnection;
    }
}

