/*
 * Decompiled with CFR 0.152.
 */
package br.com.climb.core;

import br.com.climb.configfile.FactoryConfigFile;
import br.com.climb.core.PersistentEntity;
import br.com.climb.core.interfaces.ResultIterator;
import br.com.climb.core.mapping.Entity;
import br.com.climb.core.mapping.Json;
import br.com.climb.core.mapping.QueryResult;
import br.com.climb.core.mapping.Relation;
import br.com.climb.core.mapping.Transient;
import br.com.climb.core.sqlengine.interfaces.SqlEngine;
import br.com.climb.exception.LoadLazyObjectException;
import br.com.climb.systemcache.CacheManager;
import br.com.climb.systemcache.CacheManagerImp;
import br.com.climb.utils.ReflectionUtil;
import br.com.climb.utils.SqlUtil;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LazyLoader
implements ResultIterator {
    private Connection connection;
    private Class classe;
    private ResultSet resultSet;
    private Object object;
    private SqlEngine sqlEngine;
    private static final Logger logger = LogManager.getLogger(LazyLoader.class);

    public LazyLoader(Connection connection, SqlEngine sqlEngine) {
        this.connection = connection;
        this.sqlEngine = sqlEngine;
    }

    public LazyLoader(Connection connection, SqlEngine sqlEngine, Class classe) {
        this.connection = connection;
        this.sqlEngine = sqlEngine;
        this.classe = classe;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public boolean next() {
        try {
            if (this.resultSet.next()) {
                this.object = this.newEnhancer(this.classe).create();
                Field[] fields = this.object.getClass().getSuperclass().getDeclaredFields();
                this.loadObject(fields, this.object, this.resultSet);
                return true;
            }
            this.resultSet.close();
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
        }
        return false;
    }

    public LazyLoader findWithQueryExecute(String sql) throws LoadLazyObjectException {
        QueryResult queryResult = this.classe.getAnnotation(QueryResult.class);
        if (queryResult == null) {
            throw new LoadLazyObjectException(this.classe.getName() + " not is QueryResult");
        }
        try {
            Statement stmt = this.connection.createStatement(1005, 1);
            this.resultSet = stmt.executeQuery(sql);
            return this;
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
            return null;
        }
    }

    public LazyLoader findWithWhereQueryExecute(String sql) throws LoadLazyObjectException {
        try {
            Statement stmt = this.connection.createStatement(1005, 1);
            this.resultSet = stmt.executeQuery(sql);
            return this;
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
            return null;
        }
    }

    public Object loadLazyObject(Class classe, Long id) throws Exception {
        CacheManager cacheManager = CacheManagerImp.build(FactoryConfigFile.getConfigFile());
        Object object = cacheManager.getValueCache(classe, id);
        if (object != null) {
            return object;
        }
        Entity entity = classe.getAnnotation(Entity.class);
        if (entity == null) {
            throw new LoadLazyObjectException(classe.getName() + " not is Entity");
        }
        try (Statement statement = this.connection.createStatement(1005, 1);
             ResultSet resultSet = statement.executeQuery(this.sqlEngine.generateSelectOne(classe, id));){
            while (resultSet.next()) {
                long localid = resultSet.getLong("id");
                object = this.newEnhancer(classe, entity.name(), localid).create();
                ((PersistentEntity)object).setId(localid);
                Field[] fields = object.getClass().getSuperclass().getDeclaredFields();
                this.loadObject(fields, object, resultSet);
            }
        }
        return object;
    }

    private Enhancer newEnhancer(Class classe) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(classe);
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                Object inst = proxy.invokeSuper(obj, args);
                if (inst != null && inst.getClass().getAnnotation(Entity.class) != null) {
                    Long id = ((PersistentEntity)inst).getId();
                    return LazyLoader.this.loadLazyObject(inst.getClass(), id);
                }
                return proxy.invokeSuper(obj, args);
            }
        });
        return enhancer;
    }

    private Enhancer newEnhancer(Class classe, final String entity, final long id) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(classe);
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                Object inst = proxy.invokeSuper(obj, args);
                if (inst != null) {
                    if (inst.getClass().getAnnotation(Entity.class) != null) {
                        Long id2 = ((PersistentEntity)inst).getId();
                        return LazyLoader.this.loadLazyObject(inst.getClass(), id2);
                    }
                    if (inst.getClass() == byte[].class) {
                        String fieldName = new String((byte[])inst);
                        return SqlUtil.getBinaryValue(LazyLoader.this.connection, LazyLoader.this.sqlEngine.generateSelectOneAtt(id, fieldName, entity), fieldName);
                    }
                }
                return proxy.invokeSuper(obj, args);
            }
        });
        return enhancer;
    }

    private void loadObject(Field[] fields, Object object, ResultSet resultSet) {
        for (Field field : fields) {
            Object value;
            String fieldName;
            if (field.isAnnotationPresent(Transient.class)) continue;
            if (field.isAnnotationPresent(Relation.class)) {
                try {
                    Object instance = Class.forName(field.getGenericType().getTypeName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    String fieldName2 = ReflectionUtil.getFieldName(field);
                    Long value2 = resultSet.getLong(fieldName2);
                    PersistentEntity persistentEntity = (PersistentEntity)instance;
                    persistentEntity.setId(value2);
                    new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, instance);
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (object.getClass().getSuperclass().getSuperclass() == PersistentEntity.class) {
                try {
                    ((PersistentEntity)object).setId(resultSet.getLong("id"));
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
            }
            if (field.getType() == Long.class) {
                try {
                    fieldName = ReflectionUtil.getFieldName(field);
                    value = resultSet.getLong(fieldName);
                    new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                try {
                    fieldName = ReflectionUtil.getFieldName(field);
                    value = resultSet.getInt(fieldName);
                    new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                try {
                    fieldName = ReflectionUtil.getFieldName(field);
                    value = Float.valueOf(resultSet.getFloat(fieldName));
                    new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                try {
                    fieldName = ReflectionUtil.getFieldName(field);
                    value = resultSet.getDouble(fieldName);
                    new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                try {
                    try {
                        fieldName = ReflectionUtil.getFieldName(field);
                        value = resultSet.getBoolean(fieldName);
                        new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
                    }
                    catch (Exception e) {
                        logger.error("context", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (field.getType() == String.class || field.getType() == Character.TYPE) {
                try {
                    try {
                        fieldName = ReflectionUtil.getFieldName(field);
                        value = resultSet.getString(fieldName);
                        new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
                    }
                    catch (Exception e) {
                        logger.error("context", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (field.getType() == byte[].class) {
                try {
                    try {
                        fieldName = ReflectionUtil.getFieldName(field);
                        value = fieldName.getBytes();
                        new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value);
                    }
                    catch (Exception e) {
                        logger.error("context", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
                continue;
            }
            if (field.getType() != List.class || !field.isAnnotationPresent(Json.class)) continue;
            try {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    Class fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    String fieldName3 = ReflectionUtil.getFieldName(field);
                    String json = resultSet.getString(fieldName3);
                    if (json == null || json.trim().length() <= 0) continue;
                    ArrayList value3 = (ArrayList)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, fieldType));
                    new PropertyDescriptor(field.getName(), object.getClass()).getWriteMethod().invoke(object, value3);
                }
                catch (Exception e) {
                    logger.error("context", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("context", (Throwable)e);
            }
        }
    }
}

