/*
 * Decompiled with CFR 0.152.
 */
package br.com.cefis.util;

import br.com.cefis.api.filter.Filters;
import br.com.cefis.api.filter.Pagination;
import br.com.cefis.exception.CefisException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class QueryStringFactory {
    private URIBuilder uri;
    private Pagination pagination;
    private Filters filters;
    private Map<String, String> params;

    public QueryStringFactory(String endpoint, Pagination pagination, Filters filters, Map<String, String> params) {
        try {
            this.uri = new URIBuilder(endpoint);
            this.pagination = pagination;
            this.filters = filters;
            this.params = params;
        }
        catch (URISyntaxException e) {
            throw new CefisException("Error trying to build URL: " + e.getMessage());
        }
    }

    private void addPagination() {
        if (this.pagination.getLimit() != 0) {
            this.uri.addParameter("limit", String.valueOf(this.pagination.getLimit()));
        }
        if (this.pagination.getOffset() >= 0) {
            this.uri.addParameter("offset", String.valueOf(this.pagination.getOffset()));
        }
    }

    private void addParams() {
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            this.uri.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public String generate() {
        if (this.pagination != null) {
            this.addPagination();
        }
        if (this.filters != null) {
            this.uri.addParameter("filters", this.filters.toString());
        }
        if (this.params != null) {
            this.addParams();
        }
        return this.uri.toString();
    }
}

