/*
 * Decompiled with CFR 0.152.
 */
package br.com.cefis.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLSupport
extends SSLSocketFactory {
    private SSLContext mCtx;
    private String[] mCiphers;
    private String[] mProtocols;

    public SSLSupport() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.initSSLSocketFactoryEx(null, null, null);
    }

    public SSLSupport(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.initSSLSocketFactoryEx(km, tm, random);
    }

    public SSLSupport(SSLContext ctx) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.initSSLSocketFactoryEx(ctx);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.mCiphers;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.mCiphers;
    }

    public String[] getDefaultProtocols() {
        return this.mProtocols;
    }

    public String[] getSupportedProtocols() {
        return this.mProtocols;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory factory = this.mCtx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(s, host, port, autoClose);
        ss.setEnabledProtocols(this.mProtocols);
        ss.setEnabledCipherSuites(this.mCiphers);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory factory = this.mCtx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(address, port, localAddress, localPort);
        ss.setEnabledProtocols(this.mProtocols);
        ss.setEnabledCipherSuites(this.mCiphers);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory factory = this.mCtx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port, localHost, localPort);
        ss.setEnabledProtocols(this.mProtocols);
        ss.setEnabledCipherSuites(this.mCiphers);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory factory = this.mCtx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.mProtocols);
        ss.setEnabledCipherSuites(this.mCiphers);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = this.mCtx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        ss.setEnabledProtocols(this.mProtocols);
        ss.setEnabledCipherSuites(this.mCiphers);
        return ss;
    }

    private void initSSLSocketFactoryEx(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.mCtx = SSLContext.getInstance("TLS");
        this.mCtx.init(km, tm, random);
        this.mProtocols = this.getProtocolList();
        this.mCiphers = this.getCipherList();
    }

    private void initSSLSocketFactoryEx(SSLContext ctx) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.mCtx = ctx;
        this.mProtocols = this.getProtocolList();
        this.mCiphers = this.getCipherList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getProtocolList() throws IOException {
        String[] preferredProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
        Object[] availableProtocols = null;
        try (Socket socket = null;){
            SSLSocketFactory factory = this.mCtx.getSocketFactory();
            socket = (SSLSocket)factory.createSocket();
            availableProtocols = ((SSLSocket)socket).getSupportedProtocols();
            Arrays.sort(availableProtocols);
        }
        ArrayList<String> aa = new ArrayList<String>();
        for (int i = 0; i < preferredProtocols.length; ++i) {
            int idx = Arrays.binarySearch(availableProtocols, preferredProtocols[i]);
            if (idx < 0) continue;
            aa.add(preferredProtocols[i]);
        }
        return aa.toArray(new String[0]);
    }

    protected String[] getCipherList() {
        String[] preferredCiphers = new String[]{"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305", "TLS_ECDHE_ECDSA_WITH_CHACHA20_SHA", "TLS_ECDHE_RSA_WITH_CHACHA20_SHA", "TLS_DHE_RSA_WITH_CHACHA20_POLY1305", "TLS_RSA_WITH_CHACHA20_POLY1305", "TLS_DHE_RSA_WITH_CHACHA20_SHA", "TLS_RSA_WITH_CHACHA20_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA"};
        Object[] availableCiphers = null;
        try {
            SSLSocketFactory factory = this.mCtx.getSocketFactory();
            availableCiphers = factory.getSupportedCipherSuites();
            Arrays.sort(availableCiphers);
        }
        catch (Exception e) {
            return new String[]{"TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"};
        }
        ArrayList<String> aa = new ArrayList<String>();
        for (int i = 0; i < preferredCiphers.length; ++i) {
            int idx = Arrays.binarySearch(availableCiphers, preferredCiphers[i]);
            if (idx < 0) continue;
            aa.add(preferredCiphers[i]);
        }
        aa.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV");
        return aa.toArray(new String[0]);
    }
}

