/*
 * Decompiled with CFR 0.152.
 */
package br.com.cefis.api.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Filters {
    private List<String> filters = new ArrayList<String>();

    public Filters greaterThan(String field, String value) {
        this.filters.add(String.format("%s::gt(%s)", field, value));
        return this;
    }

    public Filters greaterThanOrEqual(String field, String value) {
        this.filters.add(String.format("%s::ge(%s)", field, value));
        return this;
    }

    public Filters lessThan(String field, String value) {
        this.filters.add(String.format("%s::lt(%s)", field, value));
        return this;
    }

    public Filters between(String field, String value1, String value2) {
        this.filters.add(String.format("%s::bt(%s,%s)", field, value1, value2));
        return this;
    }

    public Filters in(String field, List<String> values) {
        this.filters.add(String.format("%s::in(%s)", field, StringUtils.join(values, (String)",")));
        return this;
    }

    public String toString() {
        return StringUtils.join(this.filters, (String)"|");
    }
}

