/*
 * Decompiled with CFR 0.152.
 */
package br.com.cefis;

import br.com.cefis.authentication.Authentication;
import br.com.cefis.exception.CefisException;
import br.com.cefis.exception.UnauthorizedException;
import br.com.cefis.exception.UnexpectedException;
import br.com.cefis.exception.ValidationException;
import br.com.cefis.resource.Errors;
import br.com.cefis.ssl.SSLSupport;
import br.com.cefis.util.DataHelper;
import br.com.cefis.util.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCefis {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCefis.class);
    public static final String PRODUCTION = "https://cefis.com.br";
    public static final String SANDBOX = "https://cefis.com.br.local";
    private static String USER_AGENT;
    private final String endpoint;
    private final Authentication authentication;
    private final Gson gson;

    public ClientCefis(String endpoint, Authentication authentication) {
        this.endpoint = endpoint;
        this.authentication = authentication;
        this.gson = GsonFactory.gson();
    }

    public <T> T post(String path, Class<T> type) {
        RequestPropsBuilder props = RequestPropsBuilder.requestPropsBuilder().method("POST").path(path).type(type).contentType(ContentType.APPLICATION_JSON);
        return this.doRequest(props);
    }

    public <T> T post(String path, Object object, Class<T> type) {
        RequestPropsBuilder props = RequestPropsBuilder.requestPropsBuilder().method("POST").path(path).object(object).type(type).contentType(ContentType.APPLICATION_JSON);
        return this.doRequest(props);
    }

    public <T> T post(String path, Object object, Class<T> type, ContentType contentType) {
        RequestPropsBuilder props = RequestPropsBuilder.requestPropsBuilder().method("POST").path(path).object(object).type(type).contentType(contentType);
        return this.doRequest(props);
    }

    public <T> T put(String path, Object object, Class<T> type) {
        RequestPropsBuilder props = RequestPropsBuilder.requestPropsBuilder().method("PUT").path(path).object(object).type(type).contentType(ContentType.APPLICATION_JSON);
        return this.doRequest(props);
    }

    public <T> T get(String path, Class<T> type) {
        RequestPropsBuilder props = RequestPropsBuilder.requestPropsBuilder().method("GET").path(path).type(type).contentType(ContentType.APPLICATION_JSON);
        return this.doRequest(props);
    }

    public <T> T get(String path, Class<T> type, String acceptVersion) {
        RequestPropsBuilder props = RequestPropsBuilder.requestPropsBuilder().method("GET").path(path).type(type).contentType(ContentType.APPLICATION_JSON).accept(acceptVersion);
        return this.doRequest(props);
    }

    public <T> T delete(String path, Class<T> type) {
        RequestPropsBuilder props = RequestPropsBuilder.requestPropsBuilder().method("DELETE").path(path).object(null).type(type).contentType(ContentType.APPLICATION_JSON);
        return this.doRequest(props);
    }

    private <T> T doRequest(RequestProps requestProps) {
        try {
            URL url = new URL(this.endpoint + requestProps.path);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setRequestProperty("Content-type", requestProps.contentType.getMimeType());
            if (requestProps.accept != null) {
                conn.setRequestProperty("Accept", requestProps.accept);
            }
            conn.setRequestMethod(requestProps.method);
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(new SSLSupport());
            }
            if (this.authentication != null) {
                this.authentication.authenticate(conn);
            }
            LOGGER.debug("---> {} {}", (Object)requestProps.method, (Object)conn.getURL().toString());
            this.logHeaders(conn.getRequestProperties().entrySet());
            if (requestProps.object != null) {
                conn.setDoOutput(true);
                String body = this.getBody(requestProps.object, requestProps.contentType);
                LOGGER.debug("{}", (Object)body);
                DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)wr, "UTF-8"));
                writer.write(body);
                writer.close();
                wr.flush();
                wr.close();
            }
            LOGGER.debug("---> END HTTP");
            int responseCode = conn.getResponseCode();
            LOGGER.debug("<--- {} {}", (Object)responseCode, (Object)conn.getResponseMessage());
            this.logHeaders(conn.getHeaderFields().entrySet());
            StringBuilder responseBody = new StringBuilder();
            responseBody = this.responseBodyTreatment(responseBody, responseCode, conn);
            LOGGER.debug("{}", (Object)responseBody.toString());
            LOGGER.debug("<-- END HTTP ({}-byte body)", (Object)conn.getContentLength());
            return (T)this.gson.fromJson(responseBody.toString(), requestProps.getType());
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new CefisException("Error occurred connecting to Cefis API: " + e.getMessage(), e);
        }
    }

    private StringBuilder responseBodyTreatment(StringBuilder responseBody, int responseCode, HttpURLConnection conn) {
        try {
            if (responseCode >= 200 && responseCode < 299) {
                responseBody = this.readBody(conn.getInputStream());
            }
            if (responseCode == 401) {
                throw new UnauthorizedException();
            }
            if (responseCode >= 400 && responseCode < 499) {
                responseBody = this.readBody(conn.getErrorStream());
                LOGGER.debug("API ERROR {}", (Object)responseBody.toString());
                Errors errors = new Errors();
                try {
                    errors = (Errors)this.gson.fromJson(responseBody.toString(), Errors.class);
                }
                catch (Exception e) {
                    LOGGER.debug("There was not possible cast the JSON to object");
                }
                throw new ValidationException(responseCode, conn.getResponseMessage(), errors);
            }
            if (responseCode >= 500) {
                throw new UnexpectedException();
            }
        }
        catch (IOException e) {
            throw new CefisException("Error occurred connecting to Cefis API: " + e.getMessage(), e);
        }
        return responseBody;
    }

    private void logHeaders(Set<Map.Entry<String, List<String>>> entries) {
        for (Map.Entry<String, List<String>> header : entries) {
            if (header.getKey() == null) continue;
            LOGGER.debug("{}: {}", (Object)header.getKey(), header.getValue());
        }
    }

    private StringBuilder readBody(InputStream inputStream) throws IOException {
        String inputLine;
        StringBuilder body = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        while ((inputLine = in.readLine()) != null) {
            body.append(inputLine);
        }
        in.close();
        return body;
    }

    private String getBody(Object object, ContentType contentType) {
        if (contentType == ContentType.APPLICATION_FORM_URLENCODED) {
            return DataHelper.jsonToUrlEncodedString((JsonObject)new JsonParser().parse(this.gson.toJson(object)));
        }
        return this.gson.toJson(object);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    static {
        try {
            InputStream inputStream = ClientCefis.class.getResourceAsStream("/cefisJavaSDK.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            USER_AGENT = properties.getProperty("userAgent");
        }
        catch (Exception e) {
            USER_AGENT = "CEFISJavaSDK/UnknownVersion (+https://bitbucket.org/cefis/cefis-sdk-java)";
        }
    }

    private static class RequestPropsBuilder
    extends RequestProps {
        private RequestPropsBuilder() {
        }

        public static RequestPropsBuilder requestPropsBuilder() {
            return new RequestPropsBuilder();
        }

        public RequestPropsBuilder method(String method) {
            this.method = method;
            return this;
        }

        public RequestPropsBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RequestPropsBuilder object(Object object) {
            this.object = object;
            return this;
        }

        public RequestPropsBuilder type(Class type) {
            this.type = type;
            return this;
        }

        public RequestPropsBuilder contentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public RequestPropsBuilder accept(String acceptVersion) {
            this.accept = this.acceptBuilder(acceptVersion);
            return this;
        }

        public String acceptBuilder(String version) {
            String value = "application/json";
            if (version == "2.1") {
                value = value + ";version=" + version;
            }
            return value;
        }
    }

    private static class RequestProps {
        protected String method;
        protected String path;
        protected Object object;
        protected Class type;
        protected ContentType contentType;
        protected String accept;

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public Object getObject() {
            return this.object;
        }

        public <T> Class<T> getType() {
            return this.type;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public String getAccept() {
            return this.accept;
        }
    }
}

