package br.com.cefis.request;


public class TeamUserRequest {

    private int teamId;
    private DepartmentRequest department;
    private PositionRequest position;
    private OccupationRequest occupation;
    private UserRequest user;

    public TeamUserRequest teamId(int teamId) {
        this.teamId = teamId;

        return this;
    }

    public TeamUserRequest department(DepartmentRequest department) {
        this.department = department;

        return this;
    }

    public TeamUserRequest position(PositionRequest position) {
        this.position = position;

        return this;
    }

    public TeamUserRequest occupation(OccupationRequest occupation) {
        this.occupation = occupation;

        return this;
    }

    public TeamUserRequest user(UserRequest user) {
        this.user = user;

        return this;
    }

    public int getTeamId() {
        return teamId;
    }

    public UserRequest getUser() {
        return user;
    }

    @Override
    public String toString() {
        return "TeamUserRequest {" +
                "teamId='" + teamId + '\'' +
                ", user='" + user + '\'' +
                ", department='" + department + '\'' +
                ", position='" + position + '\'' +
                ", occupation='" + occupation + '\'' +
                "}";
    }
}
