package br.com.cefis.exception;

import br.com.cefis.resource.Error;
import br.com.cefis.resource.Errors;

import java.util.List;

public class ValidationException extends CefisException {

    private final int responseCode;
    private final String responseStatus;
    private final Errors errors;

    public ValidationException(final int responseCode, final String responseStatus, final Errors errors) {
        this.responseCode = responseCode;
        this.responseStatus = responseStatus;
        this.errors = errors;
    }

    public int getResponseCode() {
        return responseCode;
    }

    public String getResponseStatus() {
        return responseStatus;
    }

    public Errors getError() {
        return errors;
    }

    public List<Error> getErrors() {
        return errors.getErrors();
    }
}
