package br.com.cefis.api;

import br.com.cefis.ClientCefis;
import br.com.cefis.exception.ValidationException;
import br.com.cefis.request.TeamUserRequest;
import br.com.cefis.resource.TeamUser;

public class TeamUserAPI {

    private final ClientCefis client;

    public TeamUserAPI(ClientCefis client) {
        this.client = client;
    }

    public TeamUser createOrUpdate(TeamUserRequest teamUser) {
        return client.post(String.format("/v3/team/%d/users", teamUser.getTeamId()), teamUser, TeamUser.class);
    }

    public Boolean remove(TeamUserRequest teamUser) {
        try {
            client.delete(String.format("/v3/team/%d/users/%s", teamUser.getTeamId(), teamUser.getUser().getEmail()), TeamUser.class);

            return true;
        } catch (ValidationException e) {
            if (e.getResponseCode() != 404) {
                throw new ValidationException(e.getResponseCode(), e.getResponseStatus(), e.getError());
            }
        }

        return false;
    }

}
