package br.com.carenet.poc.hapvida.utils;

import android.content.Context;
import android.util.Log;

import org.eclipse.paho.android.service.MqttAndroidClient;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

import java.util.Properties;

public class MqttHelper {
    public MqttAndroidClient mqttAndroidClient;


    // Endpoints
    // definition of urls : https://cloud.google.com/iot/docs/how-tos/mqtt-bridge
    private static final String mqttBridgeHostname = "mqtt.googleapis.com";
    private static final String mqttBridgePort     = "8883";
    private static final String cloudRegion        = "us-central1";
    private static final String registryId         = "crnt-hapvida-hom";
    String algorithm          = "ES256"; // RS256 or ES256
    String messageType        = "event";
    int numMessages           = 10;
    int tokenExpMins          = 10;
    Context context;
    private static String projectId, deviceId;

    public static void init(String _projectId, String _deviceId) {
        projectId = _projectId;
        deviceId  = _deviceId;
    }

    public MqttHelper(Context context) throws Exception{
        context           = context;
        mqttAndroidClient = new MqttAndroidClient(context, getMqttServerAddress(), getMqttClientId());
        mqttAndroidClient.setCallback(new MqttCallbackExtended() {
            @Override
            public void connectComplete(boolean b, String s) {
                Log.w("mqtt", s);
            }

            @Override
            public void connectionLost(Throwable throwable) {

            }

            @Override
            public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
                Log.w("Mqtt", mqttMessage.toString());
            }

            @Override
            public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {

            }
        });
        connect();
    }

    public static MqttCallbackExtended createAndAttachCallback(MqttClient client) throws MqttException {
        MqttCallbackExtended res = new MqttCallbackExtended() {
            @Override
            public void connectComplete(boolean b, String s) {
                Log.w("$%$%$%$% startMqtt","connectComplete");

            }

            @Override
            public void connectionLost(Throwable cause) {
                Log.w("$%$%$%$% startMqtt","connectionLost");
            }

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                String payload = new String(message.getPayload());
                System.out.println("Payload : " + payload);
                // TODO: Insert your parsing / handling of the configuration message here.
            }

            @Override
            public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
                Log.w("$%$%$%$% startMqtt","deliveryComplete");
            }
        };

        //String configTopic = String.format("/devices/%s/config", deviceId);
        //client.subscribe(configTopic, 1);

        client.setCallback(res);

        return res;
    }

    private char[] getPassword() throws Exception {
        return JwtUtil.createJwtEs(context, projectId ).toCharArray();

        /*
            long secsSinceRefresh = ((new DateTime()).getMillis() - iat.getMillis()) / 1000;
            if (secsSinceRefresh > (tokenExpMins * 60)) {
                LOGD("MqttExample", String.format("\tRefreshing token after: %d seconds\n", secsSinceRefresh));
                iat = new DateTime();
                switch (algorithm) {
                    case "RS256":
                        connectOptions.setPassword(
                                createJwtRsa2(context, projectId).toCharArray());
                        break;
                    case "ES256":
                        throw new IllegalArgumentException(
                                "Not supported at this time (VSMORI)");
                    default:
                        throw new IllegalArgumentException(
                                "Invalid algorithm " + algorithm
                                        + ". Should be one of 'RS256' or 'ES256'.");
                }
                client.disconnect();
                client.connect();
                attachCallback(client, deviceId);
            }
         */
    }

    public void setCallback(MqttCallbackExtended callback) {
        mqttAndroidClient.setCallback(callback);
    }

    private void connect() throws Exception {
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setCleanSession(false);
        mqttConnectOptions.setUserName("unused");
        mqttConnectOptions.setPassword(this.getPassword());

        try {

            mqttAndroidClient.connect(mqttConnectOptions, null, new IMqttActionListener() {
                @Override
                public void onSuccess(IMqttToken asyncActionToken) {

                    DisconnectedBufferOptions disconnectedBufferOptions = new DisconnectedBufferOptions();
                    disconnectedBufferOptions.setBufferEnabled(true);
                    disconnectedBufferOptions.setBufferSize(100);
                    disconnectedBufferOptions.setPersistBuffer(false);
                    disconnectedBufferOptions.setDeleteOldestMessages(false);
                    mqttAndroidClient.setBufferOpts(disconnectedBufferOptions);
                }

                @Override
                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    Log.w("Mqtt", "Failed to connect to: " + getMqttServerAddress() + exception.toString());
                }
            });


        } catch (MqttException ex){
            ex.printStackTrace();
        }
    }

    public static String getProjectId() {
        return projectId;
    }

    public static String getDeviceId() {
        return deviceId;
    }

    public static String getTelemetryTopic() {
        return String.format("/devices/%s/events", deviceId);
    }

    private static String getMqttServerAddress() {
        return String.format("ssl://%s:%s", mqttBridgeHostname, mqttBridgePort);
    }

    private static String getMqttClientId() {
        return String.format(
                "projects/%s/locations/%s/registries/%s/devices/%s",
                projectId, cloudRegion, registryId, deviceId);
    }

    public static MqttClient createMqttClient() throws MqttException {
        return new MqttClient(MqttHelper.getMqttServerAddress(), getMqttClientId(), new MemoryPersistence());
    }

    public static MqttConnectOptions createMqttConnectOptions(Context context, String algorithm) throws Exception {
        MqttConnectOptions connectOptions = new MqttConnectOptions();
        // Note that the Google Cloud IoT Core only supports MQTT 3.1.1, and Paho requires that we
        // explictly set this. If you don't set MQTT version, the server will immediately close its
        // connection to your device.
        connectOptions.setMqttVersion(MqttConnectOptions.MQTT_VERSION_3_1_1);

        Properties sslProps = new Properties();
        sslProps.setProperty("com.ibm.ssl.protocol", "TLSv1.2");
        connectOptions.setSSLProperties(sslProps);
        connectOptions.setUserName("unused");
        MqttHelper.setPassword(context, algorithm, connectOptions);
        //connectOptions.setAutomaticReconnect( false );

        //connectOptions.setCleanSession( true );
        //mqttConnectOptions.setKeepAliveInterval( 10 );

            /*
    * NOTE
    *   After commenting out auto reconnect,
    *   app seemed to be connected with broker at least 8h.
    *   After good night sleep, i checked the status on morning and it was still going strong
    */
        //mqttConnectOptions.setAutomaticReconnect( true );


        //VSMORI: need to investigate itens below:
//        ClientID = "app_" + Build.DEVICE + "_" + Math.random();
//        mqttConnectOptions.setWill( "/app/will", ( "uex " + "asd" ).getBytes(), 2, false );


        return connectOptions;
    }

    static void setPassword(Context context, String algorithm, MqttConnectOptions connectOptions) throws Exception {
        switch (algorithm) {
            case "RS256":
                connectOptions.setPassword(
                        JwtUtil.createJwtRsa2(context, projectId).toCharArray());
                break;
            case "ES256":
                connectOptions.setPassword(
                        JwtUtil.createJwtEs(context, projectId).toCharArray());
                break;
            default:
                throw new IllegalArgumentException(
                        "Invalid algorithm " + algorithm + ". Should be one of 'RS256' or 'ES256'.");

        }
    }
}