package br.com.carenet.poc.hapvida.utils;

import android.util.Log;

import br.com.carenet.poc.hapvida.BuildConfig;
import timber.log.Timber;


/** Helper methods that make logging more consistent throughout the app. */
public class LogUtils {
    private static final String LOG_PREFIX = "CRNT_";
    private static final int LOG_PREFIX_LENGTH = LOG_PREFIX.length();
    private static final int MAX_LOG_TAG_LENGTH = 23;

    public static String makeLogTag(String str) {
        if (str.length() > MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH) {
            return LOG_PREFIX + str.substring(0, MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH - 1);
        }
        return LOG_PREFIX + str;
    }

    /** WARNING: Don't use this when obfuscating class names with Proguard! */
    public static String makeLogTag(Class cls) {
        return makeLogTag(cls.getSimpleName());
    }

//    private static String getMessageWithUser(String message) {
//        if (Database.getCurrentUser() != null)
//            return Database.getCurrentUser().getUid() + " "+ message;
//        else
//            return message;
//    }
    private static String getMessageWithUser(String message){
        return message;
    }

    public static void LOGD(final String tag, String message) {
        if (Log.isLoggable(tag, Log.DEBUG) || BuildConfig.DEBUG) {
            Log.d(tag, message);
            Timber.d(getMessageWithUser(message));
        }
    }

    public static void LOGD(final String tag, String message, Throwable cause) {
        if (Log.isLoggable(tag, Log.DEBUG) || BuildConfig.DEBUG) {
            Log.d(tag, message, cause);
            Timber.d(getMessageWithUser(message));
        }
    }

    public static void LOGV(final String tag, String message) {
        //noinspection PointlessBooleanExpression,ConstantConditions
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.VERBOSE)) {
            Log.v(tag, message);
            Timber.v(getMessageWithUser(message));
        }
    }

    public static void LOGV(final String tag, String message, Throwable cause) {
        //noinspection PointlessBooleanExpression,ConstantConditions
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.VERBOSE)) {
            Log.v(tag, message, cause);
            Timber.v(getMessageWithUser(message));
        }
    }

    public static void LOGI(final String tag, String message) {
        Log.i(tag, getMessageWithUser(message));
        Timber.i(getMessageWithUser(message));
    }

    public static void LOGI(final String tag, String message, Throwable cause) {
        Log.i(tag, message, cause);
        Timber.i(getMessageWithUser(message));
    }

    public static void LOGW(final String tag, String message) {
        Log.w(tag, message);
        Timber.w(getMessageWithUser(message));
    }

    public static void LOGW(final String tag, String message, Throwable cause) {
        Log.w(tag, message, cause);
        Timber.w(getMessageWithUser(message));
    }

    public static void LOGE(final String tag, String message) {
        Log.e(tag, message);
        Timber.e(getMessageWithUser(message));
    }

    public static void LOGE(final String tag, String message, Throwable cause) {
        Log.e(tag, message, cause);
        Timber.e(cause, getMessageWithUser(message));
    }
}