package br.com.carenet.poc.hapvida.utils;

import android.content.Context;

import org.joda.time.DateTime;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;

import br.com.carenet.poc.hapvida.R;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

import static br.com.carenet.poc.hapvida.utils.LogUtils.LOGD;


public class JwtUtil {
    public static String createJwtRsa2(Context context, String projectId) throws Exception {
        DateTime now = new DateTime();
        // Create a JWT to authenticate this device. The device will be disconnected after the token
        // expires, and will have to reconnect with a new token. The audience field should always be set
        // to the GCP project id.
        JwtBuilder jwtBuilder =
                Jwts.builder()
                        .setIssuedAt(now.toDate())
                        .setExpiration(now.plusMinutes(20).toDate())
                        .setAudience(projectId);
        byte[] keyBytes       = new byte[16384];
        String deviceCertFile = context.getResources().getString(R.string.deviceCertificateFile);

        InputStream keyFile = context.getResources().openRawResource(context.
                getResources().getIdentifier(deviceCertFile, "raw", context.getPackageName()));

        try {
            keyFile.read(keyBytes);
        } catch (Exception e) {
            LOGD("MqttExample", "Unable to open keyfile");
        }

        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");

        return jwtBuilder.signWith(SignatureAlgorithm.RS256, kf.generatePrivate(spec)).compact();
    }

    public static String createJwtEs(Context context, String projectId) throws Exception {
        DateTime now = new DateTime();
        // Create a JWT to authenticate this device. The device will be disconnected after the token
        // expires, and will have to reconnect with a new token. The audience field should always be set
        // to the GCP project id.
        JwtBuilder jwtBuilder =
                Jwts.builder()
                        .setIssuedAt(now.toDate())
                        .setExpiration(now.plusMinutes(20).toDate())
                        .setAudience(projectId);
        byte[] keyBytes       = new byte[16384];
        String deviceCertFile = context.getResources().getString(R.string.deviceCertificateFile);
        InputStream keyFile = context.getResources().openRawResource(context.
                getResources().getIdentifier(deviceCertFile, "raw", context.getPackageName()));

        try {
            keyFile.read(keyBytes);
        } catch (Exception e) {
            LOGD("MqttExample", "Unable to open keyfile");
        }

        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("EC");

        return jwtBuilder.signWith(SignatureAlgorithm.ES256, kf.generatePrivate(spec)).compact();
    }
}