package br.com.carenet.poc.hapvida.enums;

import android.graphics.Color;

public class DataServiceStates {

    public static final String BROADCAST_ACTION           = "br.com.carenet.poc.hapvida.enums.UploadDataService.ACTION";
    public static final String BROADCAST_UPDATE_UI        = "br.com.carenet.poc.hapvida.enums.UploadDataService.UPDATE_UI";
    public static final String BROADCAST_PARAM_STATUS     = "br.com.carenet.poc.hapvida.enums.UploadDataService.STATUS";
    public static final String BROADCAST_PARAM_QUEUE_SIZE = "br.com.carenet.poc.hapvida.enums.UploadDataService.QUEUE_SIZE";
    public static final String BROADCAST_PARAM_PACKAGE_ID = "br.com.carenet.poc.hapvida.enums.UploadDataService.PACKAGE_ID";

    public static final String STATE_ACTION_STARTED = "started";

    // The background thread is connecting to mqtt
    public static final String STATE_ACTION_CONNECTING = "connecting";

    // The background thread is writing data to mqtt
    public static final String STATE_ACTION_SENDING = "sending";

    // The background thread is done
    public static final String STATE_ACTION_COMPLETE = "complete";

    // The background thread is done
    public static final String STATE_ACTION_ERROR    = "error";

    public static int getColor(String state) {
        switch(state){
            case DataServiceStates.STATE_ACTION_STARTED:
                return Color.GRAY;
            case DataServiceStates.STATE_ACTION_CONNECTING:
                return Color.WHITE;
            case DataServiceStates.STATE_ACTION_SENDING:
                return Color.YELLOW;
            case DataServiceStates.STATE_ACTION_COMPLETE:
                return Color.GREEN;
            case DataServiceStates.STATE_ACTION_ERROR:
                return Color.RED;
            default:
                return Color.BLACK;
        }
    }
}