package br.com.carenet.poc.hapvida.enums;

import android.support.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ConnectionStates {

    public static final String DISCONNECTED = "disconnected";
    public static final String CONNECTED    = "connected";

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({ DISCONNECTED, CONNECTED })
    public @interface ConnectionStatesDef {}

    public final String key;

    public ConnectionStates(@ConnectionStatesDef String key) {
        this.key = key;
    }

    public static @ConnectionStatesDef String parse( String key) throws Exception {
        switch (key) {
            case DISCONNECTED:
                return DISCONNECTED;
            case CONNECTED:
                return CONNECTED;
        }

        throw new Exception("Value not valid : "+key);
    }
}