package br.com.carenet.poc.hapvida;


import android.Manifest;
import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;

import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import com.biovotion.decoder.types.parameter.AlgoMode;
import com.biovotion.decoder.types.parameter.DeviceMode;
import com.squareup.tape2.ObjectQueue;

import org.joda.time.DateTime;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;

import br.com.carenet.poc.hapvida.enums.DataServiceStates;
import br.com.carenet.poc.hapvida.utils.MqttHelper;
import ch.hevs.biovotion.vsm.ble.scanner.VsmDiscoveryListener;
import ch.hevs.biovotion.vsm.ble.scanner.VsmScanner;
import ch.hevs.biovotion.vsm.core.VsmConnectionState;
import ch.hevs.biovotion.vsm.core.VsmDescriptor;
import ch.hevs.biovotion.vsm.core.VsmDevice;
import ch.hevs.biovotion.vsm.core.VsmDeviceListener;
import ch.hevs.biovotion.vsm.protocol.stream.StreamValue;
import ch.hevs.biovotion.vsm.protocol.stream.units.Algo1;
import ch.hevs.biovotion.vsm.protocol.stream.units.Algo2;
import ch.hevs.biovotion.vsm.protocol.stream.units.ErrorLog;
import ch.hevs.biovotion.vsm.protocol.stream.units.RawBoard;
import ch.hevs.biovotion.vsm.stream.StreamController;
import ch.hevs.biovotion.vsm.stream.StreamListener;
import ch.hevs.ble.lib.events.commands.WriteCharValue;
import ch.hevs.ble.lib.exceptions.BleScanException;
import ch.hevs.ble.lib.scanner.Scanner;

import static br.com.carenet.poc.hapvida.enums.DataServiceStates.BROADCAST_ACTION;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_COMPLETE;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_CONNECTING;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_ERROR;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_SENDING;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_STARTED;
import static br.com.carenet.poc.hapvida.utils.LogUtils.LOGE;


public class MainActivity extends BaseActivity implements VsmDeviceListener, StreamListener/*, View.OnClickListener*/ {

    private String TAG  = getClass().getSimpleName();

    //
    private final int permissionsRequestCode = 10;

    //region Device

    private final BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    //Singleton do dispositivo
    private VsmDevice vsmDevice;
    //Realiza o controle da conectividade com o Everion
    private DeviceConnectManager deviceConnectManager;
    //Faz controle do recebimento de dados
    private StreamController streamController;
    private DataModel biovotionData;
    private VsmDescriptor desc;

    //endregion

    //region booleans

    //Ativado quando o botão da Progress Dialog é pressionado
    private boolean forceSend = false;
    //Ativado quando todos os dados do dispositivo são validos
    private boolean readyToSend = false;
    //Ativado apenas quando para o modo continuo
    private boolean continuousSending = false;
    //Ativado quando o Everion está desconectando
    private boolean disconnecting = false;

    //endregion

    //region UI
    private ProgressDialog nDialog;
    private ArrayAdapter<VsmDescriptor> arrayAdapter ;
    private ArrayList<VsmDescriptor> descriptorList = new ArrayList<>();
    private ListView myListView;
    //endregion





    //Utilizar este quando houver mais de um biovotion




    DataStreamingStateReceiver dataStreamingStateReceiver =  new DataStreamingStateReceiver();


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_main);
        //Inicializando Modelo de dados
        biovotionData  = new DataModel();
        // Data sending
//        IntentFilter statusIntentFilter = new IntentFilter(BROADCAST_ACTION);
        // Registers the DownloadStateReceiver and its intent filters
//        LocalBroadcastManager.getInstance(MainActivity.this).registerReceiver(
//                dataStreamingStateReceiver,
//                statusIntentFilter);

        createQueue("workout-data");


        String projectId = getResources().getString(R.string.projectId);
        String deviceId = getResources().getString(R.string.deviceId);
        MqttHelper.init(projectId, deviceId);


        //Ativa o bluetooth automaticamente
        if(!mBluetoothAdapter.isEnabled())
            mBluetoothAdapter.enable();

        //Cria a instancia singleton do vsmDevice
        vsmDevice = VsmDevice.sharedInstance();

        //Chama a caixa de dialogo com as opções
        modeDialog();

        //Verifica se GPS está ativado
//        permissionsCheck();

        //Inicia thread da caixa de dialogo
//        mHandler.post(mRunnable);

        //Procura pelo dispositivo
//        vsmScanner.startScanning();


//        if(vsmScanner.isScanning())
//            deviceDialog();
//        runDialog();
    }


    //region Controle de UI

    //region AlertDialogs
    /*
    Inicia tela de dialogo com três opções
    Modo Simples
    Modo Continuo
    Voltar (voltar para a parent activity)
     */
    private void modeDialog(){

        boolean clientConnection = client != null && client.isConnected();
        new AlertDialog.Builder(this)
                .setTitle("Modo de Aquisição")
                .setMessage("Conexão com a base: " + (clientConnection ? "Conectado" : "Não conectado") +"\n\nEscolha o modo desejado")
                .setPositiveButton("Modo simples", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        permissionsCheck();


                    }
                })
                .setNegativeButton("Modo Contínuo", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        continuousSending = true;
                        permissionsCheck();
                    }
                })
                .setNeutralButton("Voltar", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        sendActivityResult();
                    }
                })
                .setCancelable(false)
                .show();
    }






    public void deviceDialog() {


        final AlertDialog.Builder popDialog = new AlertDialog.Builder(this);
        final LayoutInflater inflater = (LayoutInflater) this.getSystemService(LAYOUT_INFLATER_SERVICE);
        final View ViewLayout = inflater.inflate(R.layout.layout, (ViewGroup) findViewById(R.id.bt_list));

        popDialog.setTitle("Dispositivos Encontrados");
        popDialog.setView(ViewLayout);

        // create the arrayAdapter that contains the BTDevices, and set it to a ListView
        myListView = (ListView) ViewLayout.findViewById(R.id.BTList);
        arrayAdapter = new ArrayAdapter<VsmDescriptor>(this, android.R.layout.simple_list_item_1);
        myListView.setAdapter(arrayAdapter);
        myListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Log.d(TAG,"Posicão: " + position);
                desc = (VsmDescriptor) parent.getItemAtPosition(position);
            }
        });



        // put it's one to the adapter
        for(VsmDescriptor device : descriptorList)
            arrayAdapter.add(device);


        // Connectar
        popDialog.setPositiveButton("Conectar",
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int which) {
                        if(desc != null){

                            if(mBluetoothAdapter.isEnabled()){
                                dialog.dismiss();
                                mHandler.post(mRunnable);
                                connect(desc);
                            }

                            else
                                new AlertDialog.Builder(MainActivity.this)
                                        .setTitle("Bluetooth desligado")
                                        .setMessage("É necessário ativar o bluetooth para connectar")
                                        .setNeutralButton("OK", new DialogInterface.OnClickListener() {
                                            @Override
                                            public void onClick(DialogInterface dialog, int which) {
                                                deviceDialog();

                                            }
                                        })
                                        .show();
                        }
                        else{
                            new AlertDialog.Builder(MainActivity.this)
                                    .setMessage("Nenhum dispositivo selecionado")
                                    .setNeutralButton("OK", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialog, int which) {
                                            deviceDialog();

                                        }
                                    })
                                    .show();
                        }

                    }

                });

        //Voltar para a caixa anterior
        popDialog.setNegativeButton("Voltar às opções de modos", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if(vsmScanner.isScanning())
                    vsmScanner.stopScanning();
                modeDialog();

            }
        });
        popDialog.setCancelable(false);
        // Create popup and show
        popDialog.create();
        popDialog.show();

    }



    // Impede duplicação de dispositivos no ArrayList
    // Não achei necessário utilizar Set<?>
    public boolean toSet(ArrayList<VsmDescriptor> list, VsmDescriptor desc){
        for(VsmDescriptor descriptor : list){
            if(descriptor.address().equals(desc.address()))
                return false;
        }
        list.add(desc);
        arrayAdapter.add(desc);
        arrayAdapter.notifyDataSetChanged();
        return true;
    }

    Runnable errorRunnable = new Runnable() {
        @Override
        public void run() {
            errorAlertDialog.show();
            mHandler.removeCallbacks(errorRunnable);
        }
    };

    AlertDialog.Builder errorAlertDialog;
    private void errorDialog(final String message){
        mHandler.removeCallbacks(mRunnable);
        errorAlertDialog =new AlertDialog.Builder(this)
                .setCancelable(false)
                .setTitle("Erro")
                .setMessage(message)
                .setNeutralButton("OK", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        sendActivityResult();
                    }
                });
        mHandler.post(errorRunnable);

    }


    //endregion

    //region Progress Bar Dialog
    // Faz o setup da caixa de dialogo de carregamento dos dados
    private void  setupLoadingDialog(){

        //Configurando caixa de dialogo
        nDialog.setMessage("Aguardando dispositivo");
        nDialog.setTitle("Carregando dados");
        nDialog.setButton(DialogInterface.BUTTON_POSITIVE, "Retornar", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                forceSend = true;

                if(vsmDevice!= null &&vsmDevice.isDisconnected()){
                    sendActivityResult();
                    mHandler.removeCallbacks(mRunnable);
                }
                else
                    shouldIDisconnectEverion();

            }
        });
        nDialog.setIndeterminate(false);
        nDialog.setCancelable(false);
        nDialog.show();
        //Para fazer teste sem dispositivo
//        mHandler.postDelayed(mRunnable,1000);
    }

    //Atualiza a caixa de dialogo de carregamento dos dados
    private void updateLoadingDialog(){
        String result ="Dispositivo não está mandando dados.\nVerifique se está corretamente posicionado";
        if (biovotionData.getTimestamp() == null)
            biovotionData.setTimestamp(DateTime.now().toString());
        if (biovotionData !=null && !((DateTime.now().getMillis() -DateTime.parse(biovotionData.getTimestamp()).getMillis()) > 2000) ){
            //Gerando string final com todos os dados com qualidade acima de 49
            String heartRateQuality =biovotionData.getHeartRateQuality() < 50?  "Não OK": "OK";
            String spO2Quality = biovotionData.getSpO2Quality() < 50 ? "Não OK": "OK";
            String activityClassQuality = biovotionData.getActivityClassQuality() < 50? "Não OK": "OK";
            String respirationRateQuality =  biovotionData.getRespirationRateQuality() < 50? "Não OK": "OK";
            String energyQuality = biovotionData.getEnergyQuality() < 50? "Não OK": "OK";
            String hrvQuality =  biovotionData.getHrvQuality() < 50? "Não OK": "OK";
            result = String.format(
                    "Batimentos: %s\nOxigenação: %s\nC. Atividade: %s\nRespiração: %s\nEnergia: %s\nHRV: %s",
                    heartRateQuality,spO2Quality,activityClassQuality,respirationRateQuality,energyQuality,hrvQuality
            );
        }
        nDialog.setMessage(result);
    }

    /*
    Caso seja o envio simples
     */
    private void cloudUploading() {
        if (queueFile != null && queueFile.size() == 0 && currentQueueState.equals(STATE_ACTION_COMPLETE)) {
            if(!continuousSending || forceSend){
                nDialog.dismiss();
                mHandler.removeCallbacks(mRunnable);
                if(vsmDevice.isDisconnected())
                    sendActivityResult();
            }
        } else {
            String traducao ="";
            switch (currentQueueState){
                case STATE_ACTION_STARTED:
                    traducao ="Iniciado";
                    break;
                case STATE_ACTION_CONNECTING:
                    traducao = "Conectando";
                    break;
                case STATE_ACTION_ERROR:
                    traducao = "Erro";
                    break;
                case STATE_ACTION_SENDING:
                    traducao = "Enviando";
                    break;
                case STATE_ACTION_COMPLETE:
                    traducao ="Envio completo";

            }
            @SuppressLint("DefaultLocale")
            String message = String.format("Aguardando upload para a nuvem" +
                            "\nEstado atual: %s\nPacotes restantes: %d",
                    traducao,(queueFile != null ? queueFile.size():0));
            nDialog.setMessage(message);
            if(!continuousSending)
                checkDispatchQueue(false);

            mHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    cloudUploading();
                }
            },1000);
            System.gc();
        }
    }



    // não é possível mexer na caixa de dialogo fora da sua propria thread
    // por isso é necessário criar uma thread específica para ela

    private Handler mHandler = new Handler();
    private Runnable mRunnable = new Runnable() {
        @Override
        public void run() {
            if(vsmDevice != null){
                if(!nDialog.isShowing() &&  !vsmDevice.isConnected())
                    setupLoadingDialog();
                else
                if(readyToSend){
                    cloudUploading();
//                    updateLoadingDialog();
                }
                else{
                    if(vsmDevice.isConnected())
                        updateLoadingDialog();
                }
            }
            mHandler.postDelayed(this,1000);
        }
    };



    //endregion


    public void gpsDialog(){


        final Context thisContext = this;
        new AlertDialog.Builder(this)
                .setTitle("GPS DESATIVADO")
                .setMessage("O GPS esta' desativado.\nDeseja ativa-lo?")
                .setPositiveButton("SIM", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        //Abre configuracoes de GPS
                        Intent callGPSSettingIntent = new Intent(
                                android.provider.Settings.ACTION_LOCATION_SOURCE_SETTINGS);
                        startActivity(callGPSSettingIntent);
                        deviceDialog();
                        if(!vsmScanner.isScanning()){
                            vsmScanner.startScanning();
                        }
                    }
                })
                .setNegativeButton("NÃO", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        new AlertDialog.Builder(thisContext)
                                .setMessage("Para o funcionamento correto da busca por dispositivos é necessário ativar a localização\nRetornando para seleção de modos")
                                .setNeutralButton("OK", new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {
                                        modeDialog();
                                        if(vsmScanner.isScanning())
                                            vsmScanner.stopScanning();
                                    }
                                })
                                .setCancelable(false)
                                .show();
                    }
                }).show();
    }

    //endregion

    @Override
    protected void onResume(){
        super.onResume();
        nDialog = new ProgressDialog(this);
    }

    private void permissionsCheck(){
        // Here, thisActivity is the current activity

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
            if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                    Manifest.permission.ACCESS_FINE_LOCATION)) {

                // Show an expanation to the user *asynchronously* -- don't block
                // this thread waiting for the user's response! After the user
                // sees the explanation, try again to request the permission.
                new AlertDialog.Builder(this)
                        .setTitle("Acesso a localização necessário")
                        .setMessage("Para o funcionamento do dispositivo é necessário a permissão do uso da localização")
                        .setNeutralButton("OK", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                permissionsCheck();
                            }
                        })
                        .setCancelable(false)
                        .show();
        } else {

                // No explanation needed, we can request the permission.

                ActivityCompat.requestPermissions(this,
                        new String[]{Manifest.permission.ACCESS_COARSE_LOCATION,Manifest.permission.ACCESS_FINE_LOCATION},
                        permissionsRequestCode);
                // MY_PERMISSIONS_REQUEST_READ_CONTACTS is an
                // app-defined int constant. The callback method gets the
                // result of the request.
            }
        }
        else{

            LocationManager locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);

            if(!locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)){
                gpsDialog();
            }
            else{
                deviceDialog();
                if(!vsmScanner.isScanning())
                    vsmScanner.startScanning();
            }

        }
    }


    @Override
    public void onDestroy(){
        super.onDestroy();
    }


    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        switch (requestCode) {
            case permissionsRequestCode: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    // permission was granted, yay!
                   permissionsCheck();

                } else {

                    // permission denied, boo! Disable the
                    // functionality that depends on this permission.
                }
                return;
            }

            // other 'case' lines to check for other
            // permissions this app might request
        }
    }



    // Manda resultados de volta para a parent activity
    private void sendActivityResult(){
        if(nDialog.isShowing())
            nDialog.dismiss();
        //Se não houver um resquest code vindo da parent activity o valor assumirá 0(zero)
        int integer = getIntent().getIntExtra("request",0);
//        nDialog.dismiss();
        Intent intent = new Intent();
        intent.putExtra("DataModel",biovotionData.toString());
        biovotionData = new DataModel();
        System.gc();
        setResult(integer,intent);
        finish();
    }

    //Realiza a conexão com o dispositivo encontrado
    private void connect(VsmDescriptor desc) {
        vsmScanner.stopScanning();

        vsmDevice.setDescriptor(desc);
        if(deviceConnectManager == null) {
            this.deviceConnectManager = new DeviceConnectManager(this, vsmDevice, 10000);
        }
        this.deviceConnectManager.connect();
        deviceConnectManager.bind(this);
    }

//    private void scannedDescriptors(){
//        new AlertDialog.Builder(this)
//                .setAdapter(vsmDescriptorList, new DialogInterface.OnClickListener() {
//                    @Override
//                    public void onClick(DialogInterface dialog, int which) {
//
//                    }
//                })
//                .setTitle("Selecione o dispositivo")
//                .show();
//    }



    private VsmScanner vsmScanner = new VsmScanner(mBluetoothAdapter, new VsmDiscoveryListener() {
        @Override
        public void onVsmDeviceFound(@NonNull Scanner scanner, @NonNull VsmDescriptor vsmDescriptor) {
            //Utilizando apenas para testes, pois sempre será o primeiro dispositivo que achar
            //@TODO Idealmente seria uma lista de dispositivos
//            vsmDescriptorList.add(vsmDescriptor);
            //Impede que outro dispositivo possa ser colocado no descriptor
//            if(desc == null){
//                desc = vsmDescriptor;
//                connect();
//
//            }
            toSet(descriptorList,vsmDescriptor);


        }

        //This happens when  vsmScanner.stopScanning() is called``
        @Override
        public void onScanStopped(@NonNull Scanner scanner) {
            Log.d(TAG,scanner + " Stoped");


        }
        //This may happen when bluetooth is deativated
        @Override
        public void onScanError(@NonNull Scanner scanner, @NonNull BleScanException e) {
            Log.e(TAG,scanner + " failed");
            errorDialog("Erro ao procurar por dispositivo\nVerifique se o bluetooth está ligado e tente novamente");

        }
    });




    @Override
    public void onVsmDeviceReady(@NonNull VsmDevice vsmDevice) {
        Log.d(TAG,vsmDevice+ "is ready");

    }

    @Override
    public void onVsmDeviceConnecting(@NonNull VsmDevice vsmDevice) {
        Log.d(TAG,vsmDevice+ " connecting");
    }

    @Override
    public void onVsmDeviceConnected(@NonNull VsmDevice vsmDevice, boolean b) {
        Log.d(TAG,vsmDevice+ " connected");
        if(!b)
            return;
        streamController = vsmDevice.streamController();
        streamController.addListener(this);
    }

    @Override
    public void onVsmDeviceConnectionError(@NonNull VsmDevice vsmDevice, VsmConnectionState vsmConnectionState) {
        Log.d(TAG,vsmDevice+ " Connection Error: " + vsmConnectionState.statusCode());
        nDialog.dismiss();
        mHandler.removeCallbacks(mRunnable);
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                errorDialog("Erro de conexão com dispositivo\nTente novamente");
            }
        });
        deviceConnectManager.forgotDevice();
        deviceConnectManager.close();



    }


    @Override
    public void onVsmDeviceDisconnected(@NonNull VsmDevice vsmDevice, int i) {
        Log.d(TAG,vsmDevice.state()+ " disconnected");
        switch (i){
            case 133:
                //A persistencia desse faz-se necessário reiniciar o dispositivo
//                Log.e(TAG,"Erro ao preparar dispositivo, tentando novamente");
                try{
                    deviceConnectManager.forgotDevice();


                }catch (NullPointerException e){
                    Log.e(TAG,e.toString());
                }
                try {
                    deviceConnectManager.close();
                }
                catch (Exception e){
                    Log.e(TAG,e.toString());
                }
                errorDialog(i +" :Erro ao preparar dispositivo. Se este erro persistir, reinicie o Everion. Se ainda assim não resolver, despareei o dispositivo manualmente");
                mHandler.removeCallbacks(mRunnable);
//                deviceConnectManager.connect();
                break;
            case 8:
                //Falha ao adquirir notificação do Bluetooth
                Log.e(TAG,String.format("ERRO: %d",i));
                mHandler.removeCallbacks(mRunnable);
                errorDialog(i + " :Falha na aquisição de dados. Verifique se o dispositivo ainda está ligado.\n Tente novamente");
                deviceConnectManager.forgotDevice();
                deviceConnectManager.close();
                break;
            case 22:
                // Falha após ter conectado e começado a enviar dados
                Log.e(TAG,String.format("ERRO: %d",i));
                mHandler.removeCallbacks(mRunnable);
                deviceConnectManager.forgotDevice();
                deviceConnectManager.close();
                errorDialog(i + " :Tente novamente");
                break;
            // Desconectado corretamente
            case 0 :
                Log.d(TAG,"Desconectado corretamente");
                Log.d(TAG, String.format("Vsm Device is disconected: %b",this.vsmDevice.isDisconnected()));
                deviceConnectManager.close();
                boolean clientConnected = client != null && client.isConnected();
                if( !clientConnected ||forceSend || (currentQueueState != null && currentQueueState.equals(STATE_ACTION_COMPLETE) && queueFile.size() == 0)){
                    mHandler.removeCallbacks(mRunnable);
                    sendActivityResult();
                }
                else{
                    mHandler.post(mRunnable);
                }
                break;
            default:
                mHandler.removeCallbacks(mRunnable);
                deviceConnectManager.forgotDevice();
                deviceConnectManager.close();
                errorDialog(i + " :Tente novamente");
                Log.e(TAG,String.format("Não mapeado : %d",i));
        }
        //@TODO Fazer todas as condições dos envios dos dados
    }


    //Este método é chamado muitas vezes e muito rapidamente
    //Foi necessário colocar uma trava para impedir que chamasse o mesmo metodo de desconexão muitas vezes
    boolean teste;
    @Override
    public void onStreamValueReceived(@NonNull StreamValue streamValue) {

        switch (streamValue.type){
            case Algo1:
                Algo1 algo1 = (Algo1) streamValue.unit;
                biovotionData.setHeartRate(algo1.hr);
                biovotionData.setHeartRateQuality(algo1.hrQuality);
                biovotionData.setBloodPulseWave(algo1.bloodPulseWave);
                biovotionData.setBloodPerfusion(algo1.bloodPerfusion);
                biovotionData.setSpO2(algo1.spO2);
                biovotionData.setSpO2Quality(algo1.spO2Quality);
                biovotionData.setActivity(algo1.activity);
                biovotionData.setActivityClass(algo1.classActivity);
                biovotionData.setActivityClassQuality(algo1.classActivityQuality);
                biovotionData.setSteps(algo1.steps);
                break;
            case Algo2:
                Algo2 algo2 = (Algo2) streamValue.unit;
                biovotionData.setRespirationRate(algo2.respirationRate);
                biovotionData.setRespirationRateQuality(algo2.respirationRateQuality);
                biovotionData.setEnergy(algo2.energy);
                biovotionData.setEnergyQuality(algo2.energyQuality);
                biovotionData.setHrv(algo2.hrv);
                biovotionData.setHrvQuality(algo2.hrvQuality);
                break;
            case RawBoard:
                RawBoard rawBoard = (RawBoard) streamValue.unit;
                biovotionData.setLocalTemperature(rawBoard.localTemp);
                biovotionData.setBarometerTemperature(rawBoard.barometerTemp);
                biovotionData.setGsrAmplitude(rawBoard.gsrAmplitude);
                biovotionData.setGsrPhase(rawBoard.gsrPhase);
                biovotionData.setGsrImpedance((rawBoard.gsrPhase * 256 + rawBoard.gsrAmplitude)/3000);
                biovotionData.setObjectTemp(rawBoard.objectTemp);
                biovotionData.setMbar(rawBoard.mbar);
                break;
            case ErrorLog:
//                ErrorLog error = (ErrorLog) streamValue.unit
            default:
                Log.d(TAG,"SWITCH..DEFAULT");

        }
//        mHandler.post(mRunnable);

        biovotionData.setTimestamp(DateTime.now().toString());
        Log.d(TAG,biovotionData.toString());



        //Envio
        try {


            //Adicionando novos daos no arquivo
            if(!disconnecting){
                queueFile.add(biovotionData.toString().getBytes());
                //tentativa de enviar pacote de dados
                checkDispatchQueue(false);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        readyToSend =  readyToSendResult();
        shouldIDisconnectEverion();
    }

    //
    private void shouldIDisconnectEverion(){
        if((!continuousSending & readyToSend) || forceSend   ){
            if(!disconnecting){
                disconnecting = true;
                deviceConnectManager.forgotDevice();

            }

        }
    }
    Handler sendHandler = new Handler();
    Runnable sendRunnable = new Runnable() {
        @Override
        public void run() {


            if(!readyToSend)
                readyToSend =  readyToSendResult();
            if((!continuousSending & readyToSend) || forceSend   ){
                if(!disconnecting){
                    disconnecting = true;
                    deviceConnectManager.forgotDevice();

                }

            }
            sendHandler.postDelayed(this,1000);
        }
    };
    /* esta função apenas verifica se todos os dados já possuem qualidade
     *o suficiente para serem considerados dados válidos.
     *
     * Segundo a documentação do Everion(Biovotion) somente dados com qualidade
     * superior a 50 são dados válidos
     */
    private boolean readyToSendResult(){
        ArrayList<Boolean> readyArray = new ArrayList<>();
        boolean result = true;

        readyArray.add( biovotionData.getActivityClassQuality() >= 50);
        readyArray.add(biovotionData.getEnergyQuality() >= 50);
        readyArray.add(biovotionData.getHeartRateQuality() >=50);
        readyArray.add(biovotionData.getHrvQuality() >= 50);
        readyArray.add(biovotionData.getRespirationRateQuality() >= 50);
        readyArray.add(biovotionData.getSpO2Quality() >= 50);
        readyArray.add(biovotionData.getLocalTemperature() > 0);
        readyArray.add(biovotionData.getBarometerTemperature() > 0);

        for( Boolean data : readyArray)
            if(!data)
                result = data;

        return result;



    }




    //Metodo que veio com nova biblioteca
    @Override
    public void onStreamMessageReceived(@NonNull ByteBuffer byteBuffer) {
        Log.d(TAG,"onStreamMessageReceived");
    }

    //Atualiza os dados na tela foi utilizado apenas para os testes iniciais
//    public void refreshData(){
//        (MainActivity.this).runOnUiThread(new Runnable() {
//            @Override
//            public void run() {
//                bioDataText.setText(biovotionData.toString());
//            }
//        });
//    }
//    @Override
//    public void onClick(View v) {
//        if(vsmDevice.isConnected()){
////            vsmDevice.disconnect();
//            deviceConnectManager.unpair();
//            btUnpair.setText("Connect");
//        }
//
//        else {
//            scanning();
//            vsmDevice.connect(10000);
//            btUnpair.setText("Disconnect");
//        }
//    }

    //region MQTT Broadcast Receiver

    public class DataStreamingStateReceiver extends BroadcastReceiver {
        // Prevents instantiation
        private DataStreamingStateReceiver() {
        }
        // Called when the BroadcastReceiver gets an Intent it's registered to receive
        @SuppressLint({"NewApi", "DefaultLocale"})
        @Override
        public void onReceive(Context context, Intent intent) {
            if (Objects.equals(intent.getAction(), BROADCAST_ACTION)) {
                currentQueueState = intent.getStringExtra(DataServiceStates.BROADCAST_PARAM_STATUS);
                currentQueueStateDate = new DateTime();
                if (intent.getStringExtra(DataServiceStates.BROADCAST_PARAM_STATUS).equals(STATE_ACTION_COMPLETE)) {
                    try {
                        int refPackageId = intent.getIntExtra(DataServiceStates.BROADCAST_PARAM_PACKAGE_ID, -2);

                        if (refPackageId != MainActivity.this.packageId)
                            throw new Exception(String.format("Critical situation, should not happen %d != %d", refPackageId, MainActivity.this.packageId));

                        if (queueFile != null) {
                            queue = ObjectQueue.create(queueFile, converter);
                            queue.remove(getRecordsSent());

                            Intent localIntent = new Intent(DataServiceStates.BROADCAST_UPDATE_UI)
                                    .putExtra(DataServiceStates.BROADCAST_PARAM_QUEUE_SIZE, queueFile.size());
                            LocalBroadcastManager.getInstance(context).sendBroadcast(localIntent);

                            if (queue.size() > 0) {
//                                checkDispatchQueue(false);
                            }
                        }
                    } catch (Exception ex) {
                        LOGE(TAG, ex.getMessage());
                    }
                } else if (intent.getStringExtra(DataServiceStates.BROADCAST_PARAM_STATUS).equals(STATE_ACTION_ERROR)) {
                    try {
                        if (queueFile != null) {
                            Intent localIntent = new Intent(DataServiceStates.BROADCAST_UPDATE_UI)
                                    .putExtra(DataServiceStates.BROADCAST_PARAM_QUEUE_SIZE, queueFile.size());
                            LocalBroadcastManager.getInstance(context).sendBroadcast(localIntent);

                            if (queue.size() > 0) {
//                                checkDispatchQueue(false);
                            }
                        }
                    } catch (Exception ex) {
                        LOGE(TAG, ex.getMessage());
                    }
                }
            }
        }
    }
    //endregion
}
