package br.com.carenet.poc.hapvida;

import android.content.Context;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;


import com.squareup.tape2.ObjectQueue;
import com.squareup.tape2.QueueFile;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.joda.time.DateTime;

import java.io.File;
import java.io.IOException;
import java.util.List;

import br.com.carenet.poc.hapvida.utils.LogUtils;
import br.com.carenet.poc.hapvida.utils.MqttHelper;
import br.com.carenet.poc.hapvida.utils.QueueConverter;

import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_COMPLETE;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_CONNECTING;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_ERROR;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_SENDING;
import static br.com.carenet.poc.hapvida.enums.DataServiceStates.STATE_ACTION_STARTED;
import static br.com.carenet.poc.hapvida.utils.LogUtils.LOGD;
import static br.com.carenet.poc.hapvida.utils.LogUtils.LOGE;


public class BaseActivity extends AppCompatActivity {

    private static final String TAG = LogUtils.makeLogTag(BaseActivity.class);
    //region Background Data Sending VARIABLES

    final static int MIN_TRANSMISSION_QUEUE = 3;
    final static int MAX_TRANSMISSION_BLOCK = 15;
    private int recordsSent = 0;
    QueueConverter converter  = new QueueConverter();
    QueueFile queueFile;
    ObjectQueue<String> queue;
    String currentQueueState = null;
    DateTime currentQueueStateDate = new DateTime();
    protected int packageId = 0;

    //endregion


    //region Background Data Sending METHODS
    // usage: onCreate, add this.createQueue("queue name    ");
    protected void createQueue(String file) {
        File workoutDataFile = new File(getApplicationContext().getFilesDir(), "workout-data");

        try{
            testClientConnection();
        }catch (Exception e){
            Log.e(TAG,e.toString());
        }


        try {
            queueFile = new QueueFile.Builder(workoutDataFile).build();
            queue = ObjectQueue.create(queueFile, converter);
            checkDispatchQueue(false);
        } catch (Exception e) {
            //@TODO: Não pode deixar seguir, pode ser em função de disco
            //cheio ou algo assim
            LOGE(TAG, e.getMessage());
            //Aqui não precisa de mensagem de erro????
        }
    }

    public synchronized void checkDispatchQueue(boolean force) {
        try {
            if (queueFile.isEmpty()) return;
            int size = queueFile.size();
            if (!(force || size>=MIN_TRANSMISSION_QUEUE)) return;

            if (!(currentQueueState == null || currentQueueState.equals(STATE_ACTION_COMPLETE) || currentQueueState.equals(STATE_ACTION_ERROR))) {
                return; // somente um por vez, aguardar retornar
                //@TODO: watchdog, reiniciar
            }

            // No caso de erro, aguardar 5 segundos para tentar novamente
            if (currentQueueState != null
                    &&  currentQueueState.equals(STATE_ACTION_ERROR)
                    && ((DateTime.now().getMillis() - currentQueueStateDate.getMillis()) / 1000d)<5) {
                return;
            }

            currentQueueState = STATE_ACTION_STARTED;
            packageId++;
            Log.d("XXXX", String.format("packageId %d",packageId));
            List<String> data     = queue.peek(size > MAX_TRANSMISSION_BLOCK || size < 0  ? MAX_TRANSMISSION_BLOCK : size);
            StringBuilder sb      = new StringBuilder("[");
//            Intent mServiceIntent = new Intent(this, StreamingDataService.class);

            recordsSent  = data.size();

            for (int i=0; i<data.size(); i++) {
                if (i == data.size()-1)
                    sb.append(data.get(i));
                else
                    sb.append(data.get(i)).append(",\n");
            }

            sb.append("]");

//            mServiceIntent.putExtra("data", sb.toString());
//            mServiceIntent.putExtra(BROADCAST_PARAM_PACKAGE_ID, packageId);

//            startService(mServiceIntent);
            streamingMessage = sb.toString();
            streamingHandler.post(streamingRunnable);
        } catch (Exception ex) {
            currentQueueState = STATE_ACTION_ERROR;
            streamingHandler.post(streamingRunnable);
            //Exception critica, não pode acontecer
            LOGE(TAG, ex.getMessage());
        }

    }

    protected int getRecordsSent() {
        return recordsSent;
    }

    public int getQueueSize() {
        return queueFile.size();
    }

    MqttClient client ;


    public void testClientConnection() throws Exception{
        if(client == null)
            client =MqttHelper.createMqttClient();
        String algorithm                  = "ES256"; // RS256 or ES256
        MqttConnectOptions connectOptions = MqttHelper.createMqttConnectOptions(this, algorithm);
        // Both connect and publish operations may fail. If they do, allow retries but with an
        // exponential backoff time period.
        long retryIntervalMs                  = 500L;
        long maxConnectRetryTimeElapsedMillis = 1500L;
        long totalRetryTimeMs                 = 0;

        attachCallback(client);

        while (!client.isConnected() && totalRetryTimeMs < maxConnectRetryTimeElapsedMillis) {
            try {
                client.connect(connectOptions);
            } catch (MqttException e) {
                int reason = e.getReasonCode();
                // If the connection is lost or if the server cannot be connected, allow retries
                LOGD(TAG,"An error occurred: " + e.getMessage());
                if (reason == MqttException.REASON_CODE_CONNECTION_LOST
                        || reason == MqttException.REASON_CODE_SERVER_CONNECT_ERROR) {
                    LOGD(TAG,"Retrying in " + retryIntervalMs / 1000.0 + " seconds.");
                    Thread.sleep(retryIntervalMs);
                    totalRetryTimeMs += retryIntervalMs;
                } else {
                    currentQueueState = STATE_ACTION_ERROR;
                    throw e;

                }
            }
        }
    }

    public void sendData(Context context,String payload) throws Exception {



        testClientConnection();
        String mqttTopic    = MqttHelper.getTelemetryTopic();
        MqttMessage message = new MqttMessage(payload.getBytes());
        message.setQos(1);
        Log.d("JSON",payload);
        currentQueueState =STATE_ACTION_SENDING;
        //Publicando
        if(!payload.equals(""))
            client.publish(mqttTopic, message);
        streamingHandler.post(streamingRunnable);
        //endregion
    }

    private void clearQueueFile(){
        if(currentQueueState.equals(STATE_ACTION_COMPLETE)){
            if (queueFile != null) {
                if(queue == null)
                    queue = ObjectQueue.create(queueFile, converter);
                Log.d(TAG,"Tamanho: " + queue.size());

                try {
                    if (queue.size() >= getRecordsSent())
                        queue.remove(getRecordsSent());
                    else
                        queue.remove(queue.size());
                } catch (IOException e) {
                    e.printStackTrace();
                }
                if (queue.size() > 0) {
                    checkDispatchQueue(false);
                }
            }
        }
        else
            clearQueueFile();

    }

    static MqttCallbackExtended mCallback;
    private boolean finished = false;
    private boolean success  = false;


    private void attachCallback(final MqttClient client) throws MqttException {
        mCallback = new MqttCallbackExtended() {
            @Override
            public void connectComplete(boolean b, String s) {
                Log.w(TAG,"connectComplete");
            }

            @Override
            public void connectionLost(Throwable cause) {
                if (!finished) {
                    finished = true;
                    Log.w(TAG,"connectionLost");
                    currentQueueState = STATE_ACTION_ERROR;
                    streamingMessage = "conenctionLost";
                    streamingHandler.post(streamingRunnable);
                }
            }

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
            }

            @Override
            public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
                success  = true;
                currentQueueState = STATE_ACTION_COMPLETE;
                finished = true;
                streamingHandler.post(streamingRunnable);

            }
        };

        client.setCallback(mCallback);
    }

    String streamingMessage = "";
    Handler streamingHandler = new Handler();
    Runnable streamingRunnable = new Runnable() {
        @Override
        public void run() {
            dataStreaming(streamingMessage);
            streamingMessage = "";

        }
    };
    private void dataStreaming(){
        this.dataStreaming("");
    }
    private void dataStreaming(String message) {
        Log.d(TAG,String.format("Data Streaming State: %s",currentQueueState));
        switch (currentQueueState) {
            case STATE_ACTION_STARTED:
                if(message.equals(""))
                    Log.d("JSON",message);
                try {
                    sendData(this,message);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            case STATE_ACTION_CONNECTING:
                break;
            case STATE_ACTION_COMPLETE:
                clearQueueFile();
                break;
            case STATE_ACTION_ERROR:
                Log.e(TAG,message);
                break;
            case STATE_ACTION_SENDING:
                long transmissionCheckIntervalMillis    = 100L;
                long maxTransmissionCheckIntervalMillis = 3000L;
                long currentCheckIntervalMillis         = 0;
                while (!finished || currentCheckIntervalMillis>maxTransmissionCheckIntervalMillis) {
                    try {
                        Thread.sleep(transmissionCheckIntervalMillis);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    currentCheckIntervalMillis += transmissionCheckIntervalMillis;
                }

                if (!finished || !success)
                    currentQueueState =STATE_ACTION_ERROR;
                else
                    currentQueueState = STATE_ACTION_COMPLETE;

                break;

        }
    }
}
