/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.environment;

import br.com.caelum.vraptor.Get;
import br.com.caelum.vraptor.Path;
import br.com.caelum.vraptor.Put;
import br.com.caelum.vraptor.Resource;
import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.environment.Environment;
import br.com.caelum.vraptor.freemarker.Freemarker;
import freemarker.template.TemplateException;
import java.io.IOException;

@Resource
public class EnvironmentController {
    private final Result result;
    private final Environment environment;
    private final Freemarker freemarker;

    public EnvironmentController(Environment environment, Result result, Freemarker freemarker) {
        this.environment = environment;
        this.result = result;
        this.freemarker = freemarker;
    }

    @Path(value={"/admin/environment"})
    @Get
    public void list() throws IOException, TemplateException {
        if (this.isDisabled()) {
            this.result.notFound();
            return;
        }
        this.freemarker.use("list").with("environment", (Object)this.environment).render();
    }

    private boolean isDisabled() {
        return !this.environment.supports("environment.controller");
    }

    @Path(value={"/admin/environment"})
    @Put
    public void edit(String key, String value) throws IOException, TemplateException {
        if (this.isDisabled()) {
            this.result.notFound();
            return;
        }
        this.environment.set(key, value);
        ((EnvironmentController)this.result.redirectTo((Object)this)).list();
    }
}

