/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.verifier;

import br.com.caelum.brutauth.auth.annotations.AccessLevel;
import br.com.caelum.brutauth.auth.annotations.SimpleBrutauthRules;
import br.com.caelum.brutauth.auth.rules.SimpleBrutauthRule;
import br.com.caelum.brutauth.interceptors.BrutauthClassOrMethod;
import br.com.caelum.brutauth.reflection.Argument;
import br.com.caelum.brutauth.verifier.BrutauthRulesVerifier;
import br.com.caelum.brutauth.verifier.GenericRulesVerifier;
import java.lang.annotation.Annotation;
import javax.inject.Inject;

public class SimpleBrutauthRulesVerifier
implements BrutauthRulesVerifier {
    public static final String ACCESS_LEVEL_ARG_NAME = "accessLevel";
    private final GenericRulesVerifier genericVerifier;

    public SimpleBrutauthRulesVerifier() {
        this(null);
    }

    @Inject
    public SimpleBrutauthRulesVerifier(GenericRulesVerifier genericVerifier) {
        this.genericVerifier = genericVerifier;
    }

    @Override
    public boolean rulesOfTypeAllows(BrutauthClassOrMethod type) {
        SimpleBrutauthRules annotation = type.getAnnotation(SimpleBrutauthRules.class);
        Class<? extends SimpleBrutauthRule>[] rules = annotation.value();
        long permissionData = 0L;
        if (type.containsAnnotation(AccessLevel.class)) {
            permissionData = type.getAnnotation(AccessLevel.class).value();
        }
        return this.genericVerifier.verify(rules, new Argument[]{new Argument(ACCESS_LEVEL_ARG_NAME, permissionData)});
    }

    @Override
    public boolean canVerify(Class<? extends Annotation> annotation) {
        return SimpleBrutauthRules.class.isAssignableFrom(annotation);
    }
}

