/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.verifier;

import br.com.caelum.brutauth.auth.rules.BrutauthRule;
import br.com.caelum.brutauth.auth.rules.GlobalRuleProducer;
import br.com.caelum.brutauth.interceptors.BrutauthClassOrMethod;
import br.com.caelum.brutauth.verifier.BrutauthRulesVerifier;
import br.com.caelum.brutauth.verifier.SingleRuleVerifier;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

public class BrutauthRulesVerifiers {
    private final Instance<BrutauthRulesVerifier> verifiers;
    private final SingleRuleVerifier singleVerifier;
    private GlobalRuleProducer defaultRuleProvider;

    @Inject
    public BrutauthRulesVerifiers(Instance<BrutauthRulesVerifier> verifiers, GlobalRuleProducer globalRuleProvider, SingleRuleVerifier singleVerifier) {
        this.verifiers = verifiers;
        this.defaultRuleProvider = globalRuleProvider;
        this.singleVerifier = singleVerifier;
    }

    protected BrutauthRulesVerifiers() {
        this(null, null, null);
    }

    public boolean verify(BrutauthClassOrMethod type) {
        boolean userDefinedGlobalRule;
        List<Annotation> annotations = type.getAnnotations();
        for (BrutauthRulesVerifier verifier : this.verifiers) {
            for (Annotation annotation : annotations) {
                if (!verifier.canVerify(annotation.annotationType()) || verifier.rulesOfTypeAllows(type)) continue;
                return false;
            }
        }
        BrutauthRule globalRule = this.defaultRuleProvider.getInstance();
        boolean bl = userDefinedGlobalRule = globalRule != null;
        if (userDefinedGlobalRule) {
            return this.singleVerifier.verify(globalRule, null);
        }
        return true;
    }
}

