/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.reflection;

import br.com.caelum.brutauth.auth.rules.CustomBrutauthRule;
import br.com.caelum.brutauth.reflection.Argument;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.vidageek.mirror.dsl.ClassController;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.list.dsl.Matcher;
import net.vidageek.mirror.list.dsl.MirrorList;

public class BrutauthMethod {
    private final Method methodToInvoke;
    private Object[] argumentValues;
    private CustomBrutauthRule toInvoke;

    public BrutauthMethod(Argument[] arguments, Method defaultMethod, CustomBrutauthRule toInvoke) throws NoSuchMethodException, SecurityException {
        this.argumentValues = this.toValue(arguments);
        this.toInvoke = toInvoke;
        this.methodToInvoke = this.getMethodToInvoke(toInvoke.getClass(), defaultMethod.getName(), this.argumentValues);
    }

    private Object[] toValue(Argument[] arguments) {
        if (arguments == null) {
            return null;
        }
        Object[] values = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            values[i] = argument == null ? null : argument.getValue();
        }
        return values;
    }

    public boolean invoke() {
        return (Boolean)new Mirror().on((Object)this.toInvoke).invoke().method(this.methodToInvoke).withArgs(this.argumentValues);
    }

    public Method getMethod() {
        return this.methodToInvoke;
    }

    private Method getMethodToInvoke(Class<?> toInvoke, String methodName, Object[] arguments) throws NoSuchMethodException, SecurityException {
        ClassController clazz = new Mirror().on(toInvoke);
        if (arguments == null) {
            return clazz.reflect().method(methodName).withoutArgs();
        }
        MirrorList matching = clazz.reflectAll().methods().matching(this.havingSomeOfThese(methodName, arguments));
        if (matching.isEmpty()) {
            throw new IllegalArgumentException("Didn't find any methods with name " + methodName + " and arguments " + Arrays.asList(arguments));
        }
        return (Method)matching.get(0);
    }

    private Matcher<Method> havingSomeOfThese(final String methodName, final Object[] arguments) {
        return new Matcher<Method>(){

            public boolean accepts(Method element) {
                Class<?>[] parameterTypes = element.getParameterTypes();
                if (!element.getName().equals(methodName)) {
                    return false;
                }
                if (parameterTypes.length != arguments.length) {
                    return false;
                }
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (arguments[i] == null || parameterTypes[i].isAssignableFrom(arguments[i].getClass())) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

