/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.reflection;

import br.com.caelum.brutauth.reflection.MatchLevel;
import br.com.caelum.brutauth.reflection.Parameter;

public class Argument {
    private String name;
    private Object value;

    public Argument(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public MatchLevel matches(Parameter param) {
        boolean typesAreEquals = this.value.getClass().isAssignableFrom(param.getType());
        boolean namesAreEquals = this.name.equals(param.getName());
        if (typesAreEquals) {
            if (namesAreEquals) {
                return MatchLevel.FULL;
            }
            return MatchLevel.HALF;
        }
        return MatchLevel.ZERO;
    }

    public String toString() {
        return "Argument [name=" + this.name + ", value=" + this.value + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Argument other = (Argument)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

