/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.verifier;

import br.com.caelum.brutauth.auth.annotations.CustomBrutauthRules;
import br.com.caelum.brutauth.auth.handlers.HandlerSearcher;
import br.com.caelum.brutauth.auth.handlers.RuleHandler;
import br.com.caelum.brutauth.auth.rules.CustomBrutauthRule;
import br.com.caelum.brutauth.interceptors.BrutauthClassOrMethod;
import br.com.caelum.brutauth.reflection.MethodInvoker;
import br.com.caelum.brutauth.verifier.BrutauthRulesVerifier;
import br.com.caelum.brutauth.verifier.MethodArguments;
import br.com.caelum.vraptor.ioc.Container;
import javax.inject.Inject;

public class CustomBrutauthRulesVerifier
implements BrutauthRulesVerifier {
    private final Container container;
    private final MethodInvoker invoker;
    private final HandlerSearcher handlers;
    private final MethodArguments arguments;

    public CustomBrutauthRulesVerifier() {
        this(null, null, null, null);
    }

    @Inject
    public CustomBrutauthRulesVerifier(Container container, MethodArguments arguments, MethodInvoker invoker, HandlerSearcher handlers) {
        this.container = container;
        this.arguments = arguments;
        this.invoker = invoker;
        this.handlers = handlers;
    }

    @Override
    public boolean rulesOfTypeAllows(BrutauthClassOrMethod type) {
        boolean rulesAllows = true;
        if (type.containsAnnotation(CustomBrutauthRules.class)) {
            CustomBrutauthRules annotation = type.getAnnotation(CustomBrutauthRules.class);
            Class<? extends CustomBrutauthRule>[] rules = annotation.value();
            rulesAllows = this.rulesAllows(rules);
        }
        return rulesAllows;
    }

    private boolean rulesAllows(Class<? extends CustomBrutauthRule>[] rules) {
        for (Class<? extends CustomBrutauthRule> rule : rules) {
            CustomBrutauthRule brutauthRule = (CustomBrutauthRule)this.container.instanceFor(rule);
            boolean allowed = this.invoker.invoke(brutauthRule, this.arguments.getValuedArguments());
            RuleHandler handler = this.handlers.getHandler(brutauthRule);
            if (allowed) continue;
            handler.handle();
            return false;
        }
        return true;
    }
}

