/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.interceptors;

import br.com.caelum.brutauth.auth.annotations.SimpleBrutauthRules;
import br.com.caelum.brutauth.interceptors.BrutauthClassOrMethod;
import br.com.caelum.brutauth.verifier.SimpleBrutauthRulesVerifier;
import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import javax.inject.Inject;

@Intercepts
public class SimpleBrutauthRuleInterceptor
implements Interceptor {
    private SimpleBrutauthRulesVerifier verifier;

    public SimpleBrutauthRuleInterceptor() {
        this(null);
    }

    @Inject
    public SimpleBrutauthRuleInterceptor(SimpleBrutauthRulesVerifier verifier) {
        this.verifier = verifier;
    }

    public void intercept(InterceptorStack stack, ControllerMethod method, Object controllerInstance) throws InterceptionException {
        BrutauthClassOrMethod controllerType = new BrutauthClassOrMethod(method.getController().getType());
        if (!this.verifier.rulesOfTypeAllows(controllerType)) {
            return;
        }
        BrutauthClassOrMethod methodType = new BrutauthClassOrMethod(method.getMethod());
        if (!this.verifier.rulesOfTypeAllows(methodType)) {
            return;
        }
        stack.next(method, controllerInstance);
    }

    public boolean accepts(ControllerMethod method) {
        return method.containsAnnotation(SimpleBrutauthRules.class) || method.getController().getType().isAnnotationPresent(SimpleBrutauthRules.class);
    }
}

