/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.interceptors;

import br.com.caelum.brutauth.auth.annotations.CustomBrutauthRules;
import br.com.caelum.brutauth.interceptors.BrutauthClassOrMethod;
import br.com.caelum.brutauth.verifier.CustomBrutauthRulesVerifier;
import br.com.caelum.vraptor.InterceptionException;
import br.com.caelum.vraptor.Intercepts;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.InterceptorStack;
import br.com.caelum.vraptor.interceptor.Interceptor;
import javax.inject.Inject;

@Intercepts
public class CustomBrutauthRuleInterceptor
implements Interceptor {
    private CustomBrutauthRulesVerifier verifier;

    public CustomBrutauthRuleInterceptor() {
    }

    @Inject
    public CustomBrutauthRuleInterceptor(CustomBrutauthRulesVerifier verifier) {
        this.verifier = verifier;
    }

    public void intercept(InterceptorStack stack, ControllerMethod method, Object controllerInstance) throws InterceptionException {
        BrutauthClassOrMethod controllerType = new BrutauthClassOrMethod(method.getController().getType());
        if (!this.verifier.rulesOfTypeAllows(controllerType)) {
            return;
        }
        BrutauthClassOrMethod methodtype = new BrutauthClassOrMethod(method.getMethod());
        if (!this.verifier.rulesOfTypeAllows(methodtype)) {
            return;
        }
        stack.next(method, controllerInstance);
    }

    public boolean accepts(ControllerMethod method) {
        return method.containsAnnotation(CustomBrutauthRules.class) || method.getController().getType().isAnnotationPresent(CustomBrutauthRules.class);
    }
}

