/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.brutauth.auth.handlers;

import br.com.caelum.brutauth.auth.annotations.HandledBy;
import br.com.caelum.brutauth.auth.handlers.AccessNotAllowedHandler;
import br.com.caelum.brutauth.auth.handlers.RuleHandler;
import br.com.caelum.brutauth.auth.rules.BrutauthRule;
import br.com.caelum.vraptor.controller.BeanClass;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.ioc.Container;
import javax.inject.Inject;

public class HandlerSearcher {
    private Container container;
    private ControllerMethod controllerMethod;

    @Deprecated
    public HandlerSearcher() {
    }

    @Inject
    public HandlerSearcher(Container container, ControllerMethod controllerMethod) {
        this.container = container;
        this.controllerMethod = controllerMethod;
    }

    public RuleHandler getHandler(BrutauthRule rule) {
        if (this.controllerMethodContainsSpecificHandler(this.controllerMethod)) {
            HandledBy handledBy = this.controllerMethod.getMethod().getAnnotation(HandledBy.class);
            return (RuleHandler)this.container.instanceFor(handledBy.value());
        }
        BeanClass resource = this.controllerMethod.getController();
        if (this.resourceClassContainsSpecificHandler(resource)) {
            HandledBy handledBy = resource.getType().getAnnotation(HandledBy.class);
            return (RuleHandler)this.container.instanceFor(handledBy.value());
        }
        if (this.ruleContainsSpecificHandler(rule)) {
            HandledBy handledBy = rule.getClass().getAnnotation(HandledBy.class);
            return (RuleHandler)this.container.instanceFor(handledBy.value());
        }
        return (RuleHandler)this.container.instanceFor(AccessNotAllowedHandler.class);
    }

    private boolean controllerMethodContainsSpecificHandler(ControllerMethod controllerMethod) {
        return controllerMethod.getMethod().isAnnotationPresent(HandledBy.class);
    }

    private boolean resourceClassContainsSpecificHandler(BeanClass beanClass) {
        return beanClass.getType().isAnnotationPresent(HandledBy.class);
    }

    private boolean ruleContainsSpecificHandler(BrutauthRule rule) {
        return rule.getClass().isAnnotationPresent(HandledBy.class);
    }
}

