/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.actioncache.events;

import br.com.caelum.vraptor.actioncache.ActionCache;
import br.com.caelum.vraptor.actioncache.RequestHeaders;
import br.com.caelum.vraptor.actioncache.events.ExecuteIfNoCache;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.events.InterceptorsExecuted;
import br.com.caelum.vraptor.events.MethodExecuted;
import br.com.caelum.vraptor.events.MethodReady;
import br.com.caelum.vraptor.observer.ExecuteMethod;
import br.com.caelum.vraptor.validator.Validator;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;

@Specializes
public class CachedExecuteMethod
extends ExecuteMethod {
    private ActionCache actionCache;
    private RequestHeaders requestHeaders;

    @Inject
    public CachedExecuteMethod(MethodInfo methodInfo, Validator validator, Event<MethodExecuted> methodExecutedEvent, Event<MethodReady> readyToExecuteMethod, ActionCache actionCache, HttpServletResponse response, RequestHeaders requestHeaders) {
        super(methodInfo, validator, methodExecutedEvent, readyToExecuteMethod);
        this.actionCache = actionCache;
        this.requestHeaders = requestHeaders;
    }

    public void execute(final @Observes InterceptorsExecuted stack) {
        ExecuteIfNoCache executeIfNoCache = new ExecuteIfNoCache(stack.getControllerMethod(), this.actionCache, this.requestHeaders);
        executeIfNoCache.execute(new Runnable(){

            @Override
            public void run() {
                CachedExecuteMethod.super.execute(stack);
            }
        });
    }
}

