/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.actioncache;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.enterprise.inject.Vetoed;
import javax.servlet.http.HttpServletResponse;

@Vetoed
public class CachedWriter
extends PrintWriter {
    private final CharArrayWriter charArray = new CharArrayWriter();
    private final PrintWriter printWriter = new PrintWriter(this.charArray);

    public CachedWriter(HttpServletResponse response) throws IOException {
        super(response.getWriter());
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        super.write(cbuf, off, len);
        this.printWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() {
        super.flush();
        this.printWriter.flush();
    }

    @Override
    public void close() {
        super.close();
        this.printWriter.close();
    }

    @Override
    public void print(String s) {
        super.print(s);
        this.printWriter.print(s);
    }

    public String getOutput() {
        return this.charArray.toString();
    }
}

