/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.actioncache;

import br.com.caelum.vraptor.actioncache.Cached;
import br.com.caelum.vraptor.actioncache.RequestHeaders;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class CacheKey {
    private String userKey;
    private Map<String, String> headers = new HashMap<String, String>();
    private Set<String> cacheableHeaders = Sets.newHashSet((Object[])new String[]{"accept", "accept-language"});
    private String calculatedKey;
    private int duration;
    private int idleTime;

    public CacheKey(Cached cached, RequestHeaders requestHeaders) {
        this.userKey = cached.key();
        this.duration = cached.duration();
        this.idleTime = cached.idleTime();
        if (cached.headers()) {
            this.headers = Maps.filterKeys(requestHeaders.get(), (Predicate)new Predicate<String>(){

                public boolean apply(String key) {
                    return CacheKey.this.cacheableHeaders.contains(key.toLowerCase());
                }
            });
        }
        this.calculatedKey = this.calculateKey();
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public int getDuration() {
        return this.duration;
    }

    private String calculateKey() {
        StringBuilder key = new StringBuilder(this.userKey + ".");
        for (String header : this.headers.values()) {
            key.append(header);
        }
        return key.toString();
    }

    public String value() {
        return this.calculatedKey;
    }

    public CacheKey(String userKey) {
        this.userKey = userKey;
    }

    public Map<String, String> getHeaders() {
        return ImmutableMap.copyOf(this.headers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.userKey == null ? 0 : this.userKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey other = (CacheKey)obj;
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        return !(this.userKey == null ? other.userKey != null : !this.userKey.equals(other.userKey));
    }
}

