/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.actioncache;

import br.com.caelum.vraptor.actioncache.ActionCacheEntry;
import br.com.caelum.vraptor.actioncache.CacheKey;
import br.com.caelum.vraptor.actioncache.EhCacheVersion;
import br.com.caelum.vraptor.cache.CacheException;
import br.com.caelum.vraptor.cache.CacheStore;
import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

@ApplicationScoped
@EhCacheVersion
public class EhCacheStore
implements CacheStore<CacheKey, ActionCacheEntry> {
    private CacheManager cacheManager = CacheManager.create();
    private Cache cache;

    @PostConstruct
    public void setup() {
        this.cacheManager.addCache("pages");
        this.cache = this.cacheManager.getCache("pages");
    }

    @PreDestroy
    public void destroy() {
        this.cacheManager.shutdown();
    }

    public ActionCacheEntry write(CacheKey key, ActionCacheEntry value) {
        Element element = new Element((Object)key, (Object)value, Boolean.valueOf(false), Integer.valueOf(key.getIdleTime()), Integer.valueOf(key.getDuration()));
        this.cache.put(element);
        return value;
    }

    public ActionCacheEntry fetch(CacheKey key) {
        Element element = this.cache.get((Object)key);
        return element != null ? (ActionCacheEntry)element.getValue() : null;
    }

    public ActionCacheEntry fetch(CacheKey key, Callable<ActionCacheEntry> valueProvider) {
        if (this.cache.isKeyInCache((Object)key)) {
            return (ActionCacheEntry)this.cache.get((Object)key).getValue();
        }
        try {
            ActionCacheEntry entry = valueProvider.call();
            return this.write(key, entry);
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new CacheException("Error computing the value", e);
        }
    }
}

