/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.actioncache;

import br.com.caelum.vraptor.http.VRaptorResponse;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import javax.servlet.http.HttpServletResponse;

@Vetoed
public class CharArrayWriterResponse
extends VRaptorResponse {
    private final CharArrayWriter charArray = new CharArrayWriter();
    private HttpServletResponse originalResponse;
    private Map<String, String> headers = new HashMap<String, String>();

    public CharArrayWriterResponse(HttpServletResponse response) {
        super(response);
        this.originalResponse = response;
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(this.charArray);
    }

    public String getOutput() {
        return this.charArray.toString();
    }

    public HttpServletResponse delegate() {
        return this.originalResponse;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.keepHeader("Content-Type", type);
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        this.keepHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        this.keepHeader(name, String.valueOf(date));
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(name, value);
        this.keepHeader(name, String.valueOf(value));
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        this.keepHeader(name, String.valueOf(date));
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.keepHeader(name, String.valueOf(value));
    }

    private void keepHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

