/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.cdi.extensions;

import br.com.caelum.vraptor.core.BaseComponents;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import net.vidageek.mirror.dsl.Matcher;
import net.vidageek.mirror.dsl.Mirror;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;

public class AddInjectToConstructorExtension {
    private final AnnotatedTypeBuilder builder;

    public AddInjectToConstructorExtension(AnnotatedTypeBuilder builder) {
        this.builder = builder;
    }

    public void processAnnotatedType(@Observes ProcessAnnotatedType pat) {
        HashSet stereotypes = Sets.newHashSet((Object[])BaseComponents.getStereotypes());
        for (Class stereotype : stereotypes) {
            for (Annotation foundAnnotation : pat.getAnnotatedType().getAnnotations()) {
                if (!foundAnnotation.annotationType().equals(stereotype)) continue;
                this.tryToDefineInjectConstructor(pat, this.builder);
                return;
            }
        }
    }

    private void tryToDefineInjectConstructor(ProcessAnnotatedType pat, AnnotatedTypeBuilder builder) {
        boolean hasArgsConstructorAndNoInjection;
        Class componentClass = pat.getAnnotatedType().getJavaClass();
        List constructors = new Mirror().on(componentClass).reflectAll().constructorsMatching((net.vidageek.mirror.list.dsl.Matcher)new ArgsAndNoInjectConstructorMatcher());
        boolean bl = hasArgsConstructorAndNoInjection = !constructors.isEmpty();
        if (hasArgsConstructorAndNoInjection) {
            Constructor constructor = (Constructor)constructors.get(0);
            builder.addToConstructor(constructor, (Annotation)new AnnotationLiteral<Inject>(){});
        }
    }

    private static class ArgsAndNoInjectConstructorMatcher
    implements Matcher<Constructor> {
        private ArgsAndNoInjectConstructorMatcher() {
        }

        public boolean accepts(Constructor constructor) {
            boolean hasInject = constructor.isAnnotationPresent(Inject.class);
            boolean hasParameters = constructor.getParameterTypes().length > 0;
            return !hasInject && hasParameters;
        }
    }
}

