/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.cdi;

import br.com.caelum.vraptor.ioc.StereotypeHandler;
import br.com.caelum.vraptor.ioc.cdi.BeanManagerUtil;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class StereotypesRegistry {
    private final BeanManagerUtil beanManagerUtil;

    public StereotypesRegistry(BeanManager bm) {
        this.beanManagerUtil = new BeanManagerUtil(bm);
    }

    public void configure() {
        ArrayList<StereotypeHandler> stereotypesHandler = new ArrayList<StereotypeHandler>();
        Set<Bean<?>> stereotypeBeans = this.beanManagerUtil.getBeans(StereotypeHandler.class);
        for (Bean<?> bean : stereotypeBeans) {
            StereotypeHandler stereotype = (StereotypeHandler)this.beanManagerUtil.instanceFor(bean);
            stereotypesHandler.add(stereotype);
        }
        Set<Bean<?>> beans = this.beanManagerUtil.getBeans(Object.class);
        for (Bean<?> bean : beans) {
            for (StereotypeHandler handler : stereotypesHandler) {
                if (!bean.getBeanClass().isAnnotationPresent(handler.stereotype())) continue;
                handler.handle(bean.getBeanClass());
            }
        }
    }
}

