/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.cdi;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.ioc.SessionScoped;
import br.com.caelum.vraptor.ioc.cdi.ScopeInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;

public class ScopesUtil {
    private final List cdiScopes = Arrays.asList(javax.enterprise.context.ApplicationScoped.class, javax.enterprise.context.SessionScoped.class, Dependent.class, javax.enterprise.context.RequestScoped.class);
    private final List vraptorScopes = Arrays.asList(ApplicationScoped.class, SessionScoped.class, RequestScoped.class, PrototypeScoped.class);
    private final Map<Class<? extends Annotation>, Class<? extends Annotation>> cdiToVraptorScopes = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>();

    public ScopesUtil() {
        this.cdiToVraptorScopes.put(javax.enterprise.context.ApplicationScoped.class, ApplicationScoped.class);
        this.cdiToVraptorScopes.put(javax.enterprise.context.SessionScoped.class, SessionScoped.class);
        this.cdiToVraptorScopes.put(javax.enterprise.context.RequestScoped.class, RequestScoped.class);
        this.cdiToVraptorScopes.put(Dependent.class, PrototypeScoped.class);
    }

    private HashSet<Class<? extends Annotation>> findAnnotations(Class<?> componentType, List scopesAnnotation) {
        Annotation[] annotations = componentType.getAnnotations();
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        for (Annotation componentAnnotation : annotations) {
            for (Class scopeAnnotation : scopesAnnotation) {
                if (!componentAnnotation.annotationType().equals(scopeAnnotation)) continue;
                result.add(componentAnnotation.annotationType());
            }
        }
        return result;
    }

    private HashSet<Class<? extends Annotation>> cdiScopes(Class<?> componentType) {
        return this.findAnnotations(componentType, this.cdiScopes);
    }

    public ScopeInfo isScoped(Class<?> clazz) {
        ScopeInfo scopedInfo = new ScopeInfo();
        Iterator<Class<? extends Annotation>> iterator = this.cdiScopes(clazz).iterator();
        if (iterator.hasNext()) {
            Class<? extends Annotation> cdiScope = iterator.next();
            scopedInfo.setScope(this.cdiToVraptorScopes.get(cdiScope));
            return scopedInfo;
        }
        iterator = this.vraptorScopes(clazz).iterator();
        if (iterator.hasNext()) {
            Class<? extends Annotation> vraptorScope = iterator.next();
            scopedInfo.setScope(vraptorScope);
        }
        return scopedInfo;
    }

    private HashSet<Class<? extends Annotation>> vraptorScopes(Class<?> componentType) {
        return this.findAnnotations(componentType, this.vraptorScopes);
    }
}

