/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.cdi;

import br.com.caelum.vraptor.VRaptorException;
import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.ioc.PrototypeScoped;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.ioc.SessionScoped;
import br.com.caelum.vraptor.ioc.cdi.ScopeInfo;
import br.com.caelum.vraptor.ioc.cdi.ScopesUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;

public class ComponentFactoryAnnotatedTypeBuilderCreator {
    private AnnotatedTypeBuilder builder;
    private final Map<Class<? extends Annotation>, AnnotationLiteral<? extends Annotation>> vraptorToCDIScopes = new HashMap<Class<? extends Annotation>, AnnotationLiteral<? extends Annotation>>();

    public ComponentFactoryAnnotatedTypeBuilderCreator(AnnotatedTypeBuilder builder) {
        this.vraptorToCDIScopes.put(ApplicationScoped.class, (AnnotationLiteral<? extends Annotation>)new AnnotationLiteral<javax.enterprise.context.ApplicationScoped>(){});
        this.vraptorToCDIScopes.put(SessionScoped.class, (AnnotationLiteral<? extends Annotation>)new AnnotationLiteral<javax.enterprise.context.SessionScoped>(){});
        this.vraptorToCDIScopes.put(RequestScoped.class, (AnnotationLiteral<? extends Annotation>)new AnnotationLiteral<javax.enterprise.context.RequestScoped>(){});
        this.vraptorToCDIScopes.put(PrototypeScoped.class, (AnnotationLiteral<? extends Annotation>)new AnnotationLiteral<Dependent>(){});
        this.builder = builder;
    }

    public ComponentFactoryAnnotatedTypeBuilderCreator() {
        this(new AnnotatedTypeBuilder());
    }

    public AnnotatedTypeBuilder create(Class klass) {
        this.builder.readFromType(klass);
        ScopeInfo scopedInfo = new ScopesUtil().isScoped(klass);
        if (!scopedInfo.hasScope()) {
            scopedInfo.setScope(RequestScoped.class);
        }
        return this.create(klass, scopedInfo);
    }

    private AnnotatedTypeBuilder create(Class klass, ScopeInfo scopeInfo) {
        try {
            Method getInstance = klass.getMethod("getInstance", new Class[0]);
            this.builder.addToMethod(getInstance, (Annotation)new AnnotationLiteral<Produces>(){});
            this.builder.addToMethod(getInstance, (Annotation)this.vraptorToCDIScopes.get(scopeInfo.getScope()));
            return this.builder;
        }
        catch (Exception exception) {
            throw new VRaptorException((Throwable)exception);
        }
    }
}

