/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.cdi;

import br.com.caelum.vraptor.core.BaseComponents;
import br.com.caelum.vraptor.ioc.ComponentFactory;
import br.com.caelum.vraptor.ioc.cdi.CDIBasedContainer;
import br.com.caelum.vraptor.ioc.cdi.CDIFilterChainFactory;
import br.com.caelum.vraptor.ioc.cdi.CDIHttpServletRequestFactory;
import br.com.caelum.vraptor.ioc.cdi.CDIHttpServletResponseFactory;
import br.com.caelum.vraptor.ioc.cdi.CDIHttpSessionFactory;
import br.com.caelum.vraptor.ioc.cdi.CDIRequestInfoFactory;
import br.com.caelum.vraptor.ioc.cdi.ComponentFactoryAnnotatedTypeBuilderCreator;
import br.com.caelum.vraptor.ioc.cdi.ListProducer;
import br.com.caelum.vraptor.ioc.cdi.ServletContextFactory;
import java.util.Arrays;
import java.util.Collection;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;

public class CDIRegistry {
    private BeforeBeanDiscovery discovery;
    private BeanManager bm;

    public CDIRegistry(BeforeBeanDiscovery discovery, BeanManager bm) {
        this.discovery = discovery;
        this.bm = bm;
    }

    public void configure() {
        this.registerApplicationComponents();
        this.registerRequestComponents();
        this.registerPrototypeComponents();
        this.registerConverters();
        this.registerCDISpecifics();
    }

    private void registerConverters() {
        this.registerComponents(BaseComponents.getBundledConverters());
    }

    private void registerCDISpecifics() {
        this.register(CDIBasedContainer.class);
        this.register(CDIRequestInfoFactory.class);
        this.register(ServletContextFactory.class);
        this.register(CDIHttpServletRequestFactory.class);
        this.register(CDIHttpServletResponseFactory.class);
        this.register(CDIFilterChainFactory.class);
        this.register(CDIHttpSessionFactory.class);
        this.register(ListProducer.class);
    }

    private void registerPrototypeComponents() {
        this.registerComponents(BaseComponents.getPrototypeScoped().values());
    }

    private void registerRequestComponents() {
        this.registerComponents(BaseComponents.getRequestScoped().values());
    }

    private void registerApplicationComponents() {
        this.registerComponents(BaseComponents.getApplicationScoped().values());
        this.registerComponents(Arrays.asList(BaseComponents.getStereotypeHandlers()));
    }

    private <T> void registerComponents(Collection<Class<? extends T>> toRegister) {
        for (Class<T> clazz : toRegister) {
            this.register(clazz);
        }
    }

    private void register(Class<?> component) {
        try {
            if (ComponentFactory.class.isAssignableFrom(component)) {
                AnnotatedTypeBuilder builder = new ComponentFactoryAnnotatedTypeBuilderCreator().create(component);
                this.discovery.addAnnotatedType(builder.create());
            } else {
                this.discovery.addAnnotatedType(this.bm.createAnnotatedType(component));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

