/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.ioc.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

public class BeanManagerUtil {
    private BeanManager beanManager;

    public BeanManagerUtil(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public <T> T instanceFor(Class<T> type) {
        Set<Bean<?>> beans = this.getBeans(type);
        Bean bean = this.beanManager.resolve(beans);
        return this.instanceFor(bean, type);
    }

    public <T> T instanceFor(Bean<?> bean) {
        return this.instanceFor(bean, bean.getBeanClass());
    }

    public <T> T instanceFor(Bean<?> bean, Class<?> specificType) {
        if (bean == null) {
            throw new IllegalArgumentException("Bean must not be null. Class " + specificType);
        }
        CreationalContext ctx = this.beanManager.createCreationalContext(bean);
        return (T)this.beanManager.getReference(bean, specificType, ctx);
    }

    public Set<Bean<?>> getBeans(Class<?> type) {
        return this.beanManager.getBeans(type, new Annotation[0]);
    }
}

