/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.timemachine;

import br.com.caelum.timemachine.Block;
import java.lang.reflect.Field;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeMachine {
    private final DateTime somewhereInTime;

    private TimeMachine(DateTime somewhereInTime) {
        this.somewhereInTime = somewhereInTime;
    }

    public static TimeMachine goTo(DateTime somewhereInTime) {
        return new TimeMachine(somewhereInTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T andExecute(Block<T> code) {
        DateTimeUtils.MillisProvider provider = this.getCurrentTimeMillisProvider();
        DateTimeUtils.setCurrentMillisFixed((long)this.somewhereInTime.getMillis());
        try {
            T t = code.run();
            return t;
        }
        finally {
            DateTimeUtils.setCurrentMillisProvider((DateTimeUtils.MillisProvider)provider);
        }
    }

    public void andExecute(Runnable code) {
        this.andExecute(this.toBlock(code));
    }

    private Block<Void> toBlock(final Runnable code) {
        return new Block<Void>(){

            @Override
            public Void run() {
                code.run();
                return null;
            }
        };
    }

    private DateTimeUtils.MillisProvider getCurrentTimeMillisProvider() {
        try {
            Field providerField = DateTimeUtils.class.getDeclaredField("cMillisProvider");
            providerField.setAccessible(true);
            return (DateTimeUtils.MillisProvider)providerField.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedClassVersionError("The JodaTime version in use is not supported by TimeMachine. Try to use version 2.2");
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("This should not happen", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("This should not happen", e);
        }
    }
}

