/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.faces.component;

import br.com.caelum.stella.faces.component.MaskedInput;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;

@FacesRenderer(componentFamily="javax.faces.Input", rendererType="br.com.caelum.stella.faces.component.MaskedInputRenderer")
@ResourceDependencies(value={@ResourceDependency(library="jquery", name="jquery.js"), @ResourceDependency(library="mask", name="mask.js")})
public class MaskedInputRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        MaskedInput input = (MaskedInput)component;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String cpfValue = (String)requestMap.get(input.getClientId(context));
        if (cpfValue != null) {
            input.setSubmittedValue(cpfValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MaskedInput input = (MaskedInput)component;
        this.encodeMarkup(context, input);
        this.encodeScript(context, input);
    }

    private void encodeScript(FacesContext context, MaskedInput input) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function($){");
        writer.write("$('." + input.getDefaultClass() + "').mask('" + input.getMaskFormat() + "',{placeholder:'" + input.getPlaceHolder() + "'});");
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext context, MaskedInput input) throws IOException {
        Object value;
        String clientId = input.getClientId(context);
        String defaultClass = input.getDefaultClass();
        String styleClass = input.getStyleClass();
        styleClass = styleClass == null ? defaultClass : defaultClass + " " + styleClass;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("size", (Object)"14", null);
        Object object = value = input.getSubmittedValue() != null ? input.getSubmittedValue() : input.getValue();
        if (value != null) {
            writer.writeAttribute("value", (Object)value.toString(), "value");
        }
        if (input.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (input.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (input.getStyle() != null) {
            writer.writeAttribute("style", (Object)input.getStyle(), "style");
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.endElement("input");
    }
}

