/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.faces.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ResourceBundleMessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.faces.validation.ResourceBundleFinder;
import br.com.caelum.stella.type.Estado;
import br.com.caelum.stella.validation.InvalidStateException;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.RejectAllValidator;
import br.com.caelum.stella.validation.error.IEError;
import java.util.List;
import java.util.ResourceBundle;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="StellaIEValidator")
public class StellaIEValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "StellaIEValidator";
    private final ResourceBundleFinder resourceBundleFinder = new ResourceBundleFinder();
    private boolean formatted = false;
    private String estadoComponentId;
    private String estado;
    private boolean transientValue = false;
    private ValueExpression binding;

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        ResourceBundle bundle = this.resourceBundleFinder.getForCurrentLocale(facesContext);
        ResourceBundleMessageProducer producer = new ResourceBundleMessageProducer(bundle);
        try {
            br.com.caelum.stella.validation.Validator validator;
            try {
                String estadoValue;
                if (this.estado == null) {
                    ValueHolder estadoValueHolder = (ValueHolder)facesContext.getViewRoot().findComponent(this.estadoComponentId);
                    estadoValue = estadoValueHolder.getValue().toString();
                } else {
                    estadoValue = this.estado;
                }
                validator = Estado.valueOf((String)estadoValue).getIEValidator((MessageProducer)producer, this.formatted);
            }
            catch (Exception ex) {
                validator = new RejectAllValidator((MessageProducer)producer, new InvalidValue[]{IEError.UNDEFINED_STATE});
            }
            validator.assertValid((Object)value.toString());
        }
        catch (InvalidStateException e) {
            List messages = e.getInvalidMessages();
            String firstErrorMessage = ((ValidationMessage)messages.get(0)).getMessage();
            this.registerAllMessages(facesContext, uiComponent, messages.subList(1, messages.size()));
            throw new ValidatorException(new FacesMessage(firstErrorMessage));
        }
    }

    private void registerAllMessages(FacesContext facesContext, UIComponent uiComponent, List<ValidationMessage> messages) {
        for (ValidationMessage message : messages) {
            String componentId = uiComponent.getClientId(facesContext);
            facesContext.addMessage(componentId, new FacesMessage(message.getMessage()));
        }
    }

    public void setFormatted(boolean formatted) {
        this.formatted = formatted;
    }

    public void setEstadoComponentId(String estadoComponentId) {
        this.estadoComponentId = estadoComponentId;
    }

    public String getEstado() {
        return this.estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.estadoComponentId, this.formatted, this.estado, this.binding};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.estadoComponentId = (String)values[0];
        this.formatted = (Boolean)values[1];
        this.estado = (String)values[2];
        this.binding = (ValueExpression)values[3];
        if (this.binding != null) {
            this.binding.setValue(context.getELContext(), (Object)this);
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }
}

