/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IETocantinsValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("29(\\.\\d{3}){2}\\-\\d{1}");
    public static final Pattern UNFORMATED = Pattern.compile("29\\d{7}");

    public IETocantinsValidator() {
        super(true);
    }

    public IETocantinsValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IETocantinsValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        return new DigitoPara(iESemDigito).complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11).calcula();
    }
}

