/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.IEError;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class IESaoPauloProdutorRuralValidator
implements Validator<String> {
    private final boolean isFormatted;
    public static final Pattern FORMATED = Pattern.compile("P-\\d{8}\\.\\d{1}/\\d{3}");
    public static final Pattern UNFORMATED = Pattern.compile("P\\d{12}");
    private final BaseValidator baseValidator;

    public IESaoPauloProdutorRuralValidator(MessageProducer messageProducer, boolean isFormatted) {
        this.baseValidator = new BaseValidator(messageProducer);
        this.isFormatted = isFormatted;
    }

    private List<InvalidValue> getInvalidValues(String ie) {
        ArrayList<InvalidValue> errors = new ArrayList<InvalidValue>();
        errors.clear();
        if (ie != null) {
            String unformatedIE = this.checkForCorrectFormat(ie, errors);
            if (errors.isEmpty() && !this.hasValidCheckDigits(unformatedIE)) {
                errors.add(IEError.INVALID_CHECK_DIGITS);
            }
        }
        return errors;
    }

    private String checkForCorrectFormat(String ie, List<InvalidValue> errors) {
        String unformatedIE = null;
        if (this.isFormatted) {
            if (!FORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_FORMAT);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        } else {
            if (!UNFORMATED.matcher(ie).matches()) {
                errors.add(IEError.INVALID_DIGITS);
            }
            unformatedIE = ie.replaceAll("\\D", "");
        }
        return unformatedIE;
    }

    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 4);
        String digito = unformattedIE.substring(unformattedIE.length() - 4, unformattedIE.length() - 3);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        return new DigitoPara(iESemDigito).comMultiplicadores(10, 8, 7, 6, 5, 4, 3, 1).trocandoPorSeEncontrar("0", 10).trocandoPorSeEncontrar("1", 11).calcula();
    }

    @Override
    public boolean isEligible(String value) {
        boolean result = this.isFormatted ? FORMATED.matcher(value).matches() : UNFORMATED.matcher(value).matches();
        return result;
    }

    @Override
    public void assertValid(String cpf) {
        this.baseValidator.assertValid(this.getInvalidValues(cpf));
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(String cpf) {
        return this.baseValidator.generateValidationMessages(this.getInvalidValues(cpf));
    }
}

