/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IERoraimaValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("24\\d{6}\\-\\d{1}");
    public static final Pattern UNFORMATED = Pattern.compile("24\\d{7}");

    public IERoraimaValidator() {
        super(true);
    }

    public IERoraimaValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IERoraimaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 1);
        String digito = unformattedIE.substring(unformattedIE.length() - 1);
        String digitoCalculado = this.calculaDigito(iESemDigito);
        return digito.equals(digitoCalculado);
    }

    private String calculaDigito(String iESemDigito) {
        return new DigitoPara(iESemDigito).comMultiplicadores(8, 7, 6, 5, 4, 3, 2, 1).mod(9).calcula();
    }
}

